/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Chang-Tien Lu and Dechang Chen and Yufeng Kou", title="Detecting Spatial Outliers with Multiple Attributes", booktitle="Proc. 15th IEEE International Conference on Tools with Artificial Intelligence, 2003", url="http://dx.doi.org/10.1109/TAI.2003.1250179")
public class CTLuMeanMultipleAttributes<N, O extends NumberVector>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMeanMultipleAttributes.class);

    public CTLuMeanMultipleAttributes(NeighborSetPredicate.Factory<N> factory) {
        super(factory);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<O> relation2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (LOG.isDebugging()) {
            LOG.debug("Dimensionality: " + RelationUtil.dimensionality(relation2));
        }
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(RelationUtil.dimensionality(relation2));
        WritableDataStore<Vector> writableDataStore = DataStoreUtil.makeStorage(relation2.getDBIDs(), 1, Vector.class);
        Object object5 = relation2.iterDBIDs();
        while (object5.valid()) {
            object4 = (NumberVector)relation2.get((DBIDRef)object5);
            object3 = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object5);
            object2 = Centroid.make(relation2, (DBIDs)object3);
            object = object4.getColumnVector().minusEquals((Vector)object2);
            writableDataStore.put((DBIDRef)object5, (Vector)object);
            covarianceMatrix.put((Vector)object);
            object5.advance();
        }
        object5 = covarianceMatrix.getMeanVector();
        object4 = covarianceMatrix.destroyToSampleMatrix().inverse();
        object3 = new DoubleMinMax();
        object2 = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        object = relation2.iterDBIDs();
        while (object.valid()) {
            double d = MathUtil.mahalanobisDistance((Matrix)object4, (Vector)writableDataStore.get((DBIDRef)object), (Vector)object5);
            ((DoubleMinMax)object3).put(d);
            object2.putDouble((DBIDRef)object, d);
            object.advance();
        }
        object = new MaterializedDoubleRelation("mean multiple attributes spatial outlier", "mean-multipleattributes-outlier", (DoubleDataStore)object2, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object3).getMin(), ((DoubleMinMax)object3).getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, (DoubleRelation)object);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<N, O extends NumberVector>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuMeanMultipleAttributes<N, O> makeInstance() {
            return new CTLuMeanMultipleAttributes(this.npredf);
        }
    }
}

