/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.ScalesResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ListSizeConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleListParameter;

@Description(value="Setup a scaling so that all dimensions are scaled equally in visualization.")
public class AddSingleScale
implements Algorithm {
    double[] minmax = null;

    public AddSingleScale(double[] dArray) {
        this.minmax = dArray;
    }

    @Override
    public Result run(Database database) {
        for (Relation<?> relation : database.getRelations()) {
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) continue;
            ScalesResult scalesResult = this.run(relation);
            ResultUtil.addChildResult(relation, scalesResult);
        }
        return null;
    }

    private ScalesResult run(Relation<? extends NumberVector> relation) {
        Object object;
        int n = RelationUtil.dimensionality(relation);
        LinearScale[] linearScaleArray = new LinearScale[n];
        if (this.minmax == null) {
            object = new DoubleMinMax();
            Object object2 = relation.iterDBIDs();
            while (object2.valid()) {
                NumberVector numberVector = relation.get((DBIDRef)object2);
                for (int i = 0; i < n; ++i) {
                    double d = numberVector.doubleValue(i);
                    if (d != d) continue;
                    ((DoubleMinMax)object).put(d);
                }
                object2.advance();
            }
            object2 = new LinearScale(((DoubleMinMax)object).getMin(), ((DoubleMinMax)object).getMax());
            for (int i = 0; i < n; ++i) {
                linearScaleArray[i] = object2;
            }
        } else {
            object = new LinearScale(this.minmax[0], this.minmax[1]);
            for (int i = 0; i < n; ++i) {
                linearScaleArray[i] = object;
            }
        }
        object = new ScalesResult(linearScaleArray);
        return object;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MINMAX_ID = new OptionID("scales.minmax", "Forcibly set the scales to the given range.");
        double[] minmax = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleListParameter doubleListParameter = (DoubleListParameter)((DoubleListParameter)new DoubleListParameter(MINMAX_ID).setOptional(true)).addConstraint((ParameterConstraint)new ListSizeConstraint(2));
            if (parameterization.grab(doubleListParameter)) {
                this.minmax = (double[])((double[])doubleListParameter.getValue()).clone();
            }
        }

        @Override
        protected AddSingleScale makeInstance() {
            return new AddSingleScale(this.minmax);
        }
    }
}

