/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.synthetic.bymodel.GeneratorSingleCluster;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.GeneratorXMLDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.exceptions.UnableToComplyException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GeneratorXMLSpec
extends AbstractApplication {
    private static final Logging LOG = Logging.getLogger(GeneratorXMLSpec.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private File outputFile;
    private GeneratorXMLDatabaseConnection generator;

    public GeneratorXMLSpec(File file, GeneratorXMLDatabaseConnection generatorXMLDatabaseConnection) {
        this.outputFile = file;
        this.generator = generatorXMLDatabaseConnection;
    }

    @Override
    public void run() throws UnableToComplyException {
        MultipleObjectsBundle multipleObjectsBundle = this.generator.loadData();
        if (LOG.isVerbose()) {
            LOG.verbose("Writing output ...");
        }
        try {
            if (this.outputFile.exists() && LOG.isVerbose()) {
                LOG.verbose("The file " + this.outputFile + " already exists, " + "the generator result will be APPENDED.");
            }
            try (FileWriter fileWriter = new FileWriter(this.outputFile, true);){
                this.writeClusters(fileWriter, multipleObjectsBundle);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UnableToComplyException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new UnableToComplyException(iOException);
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Done.");
        }
    }

    public void writeClusters(OutputStreamWriter outputStreamWriter, MultipleObjectsBundle multipleObjectsBundle) throws IOException {
        int n;
        int n2 = -1;
        for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
            if (!TypeUtil.MODEL.isAssignableFromType(multipleObjectsBundle.meta(i))) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            throw new AbortException("No model column found in bundle.");
        }
        ArrayList<Model> arrayList = new ArrayList<Model>();
        HashMap<Model, Object> hashMap = new HashMap<Model, Object>();
        for (n = 0; n < multipleObjectsBundle.dataLength(); ++n) {
            Model model = (Model)multipleObjectsBundle.data(n, n2);
            Object object = (TIntList)hashMap.get(model);
            if (object == null) {
                arrayList.add(model);
                object = new TIntArrayList();
                hashMap.put(model, object);
            }
            object.add(n);
        }
        n = 0;
        int n3 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            n += ((TIntList)entry.getValue()).size();
            if (!(entry.getKey() instanceof GeneratorSingleCluster)) continue;
            n3 += ((GeneratorSingleCluster)entry.getKey()).getDiscarded();
        }
        double d = (double)(n + n3) / (double)n;
        outputStreamWriter.append("########################################################").append(LINE_SEPARATOR);
        outputStreamWriter.append("## Number of clusters: " + arrayList.size()).append(LINE_SEPARATOR);
        for (Model model : arrayList) {
            Object object;
            TIntList tIntList = (TIntList)hashMap.get(model);
            outputStreamWriter.append("########################################################").append(LINE_SEPARATOR);
            outputStreamWriter.append("## Size: " + tIntList.size()).append(LINE_SEPARATOR);
            if (model instanceof GeneratorSingleCluster) {
                object = (GeneratorSingleCluster)model;
                outputStreamWriter.append("########################################################").append(LINE_SEPARATOR);
                outputStreamWriter.append("## Cluster: ").append(((GeneratorSingleCluster)object).getName()).append(LINE_SEPARATOR);
                Vector vector = ((GeneratorSingleCluster)object).getClipmin();
                Vector vector2 = ((GeneratorSingleCluster)object).getClipmax();
                if (vector != null && vector2 != null) {
                    outputStreamWriter.append("## Clipping: ").append(vector.toString()).append(" - ").append(vector2.toString()).append(LINE_SEPARATOR);
                }
                outputStreamWriter.append("## Density correction factor: " + ((GeneratorSingleCluster)object).getDensityCorrection()).append(LINE_SEPARATOR);
                outputStreamWriter.append("## Generators:").append(LINE_SEPARATOR);
                for (int i = 0; i < ((GeneratorSingleCluster)object).getDim(); ++i) {
                    Distribution distribution = ((GeneratorSingleCluster)object).getDistribution(i);
                    outputStreamWriter.append("##   ").append(distribution.toString()).append(LINE_SEPARATOR);
                }
                if (((GeneratorSingleCluster)object).getTransformation() != null && ((GeneratorSingleCluster)object).getTransformation().getTransformation() != null) {
                    outputStreamWriter.append("## Affine transformation matrix:").append(LINE_SEPARATOR);
                    outputStreamWriter.append(FormatUtil.format(((GeneratorSingleCluster)object).getTransformation().getTransformation(), "## ")).append(LINE_SEPARATOR);
                }
                outputStreamWriter.append("## Discards: " + ((GeneratorSingleCluster)object).getDiscarded() + " Retries left: " + ((GeneratorSingleCluster)object).getRetries()).append(LINE_SEPARATOR);
                double d2 = (double)(((GeneratorSingleCluster)object).getSize() + ((GeneratorSingleCluster)object).getDiscarded()) / (double)((GeneratorSingleCluster)object).getSize() / d;
                outputStreamWriter.append("## Density correction factor estimation: " + d2).append(LINE_SEPARATOR);
            }
            outputStreamWriter.append("########################################################").append(LINE_SEPARATOR);
            object = tIntList.iterator();
            while (object.hasNext()) {
                int n4 = object.next();
                for (int i = 0; i < multipleObjectsBundle.metaLength(); ++i) {
                    if (i == n2) continue;
                    if (i > 0) {
                        outputStreamWriter.append(' ');
                    }
                    outputStreamWriter.append(multipleObjectsBundle.data(n4, i).toString());
                }
                outputStreamWriter.append(LINE_SEPARATOR);
            }
        }
    }

    public static void main(String[] stringArray) {
        GeneratorXMLSpec.runCLIApplication(GeneratorXMLSpec.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractApplication.Parameterizer {
        private File outputFile = null;
        private GeneratorXMLDatabaseConnection generator = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.generator = parameterization.tryInstantiate(GeneratorXMLDatabaseConnection.class);
            this.outputFile = this.getParameterOutputFile(parameterization, "The file to write the generated data set into, if the file already exists, the generated points will be appended to this file.");
        }

        @Override
        protected GeneratorXMLSpec makeInstance() {
            return new GeneratorXMLSpec(this.outputFile, this.generator);
        }
    }
}

