/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import java.util.Arrays;

public class HyperBoundingBox
implements SpatialComparable,
Externalizable {
    private static final long serialVersionUID = 1L;
    double[] min;
    double[] max;

    public HyperBoundingBox() {
    }

    public HyperBoundingBox(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("min/max need same dimensionality");
        }
        this.min = dArray;
        this.max = dArray2;
    }

    public HyperBoundingBox(SpatialComparable spatialComparable) {
        int n = spatialComparable.getDimensionality();
        this.min = new double[n];
        this.max = new double[n];
        for (int i = 0; i < n; ++i) {
            this.min[i] = spatialComparable.getMin(i);
            this.max[i] = spatialComparable.getMax(i);
        }
    }

    @Override
    public double getMin(int n) {
        return this.min[n];
    }

    @Override
    public double getMax(int n) {
        return this.max[n];
    }

    @Override
    public int getDimensionality() {
        return this.min.length;
    }

    public String toString() {
        return "[Min(" + FormatUtil.format(this.min, ",") + "), Max(" + FormatUtil.format(this.max, ",") + ")]";
    }

    public String toString(String string, NumberFormat numberFormat) {
        return string + "[Min(" + FormatUtil.format(this.min, ",", numberFormat) + "), Max(" + FormatUtil.format(this.max, ",", numberFormat) + ")]";
    }

    public boolean equals(Object object) {
        HyperBoundingBox hyperBoundingBox = (HyperBoundingBox)object;
        return Arrays.equals(this.min, hyperBoundingBox.min) && Arrays.equals(this.max, hyperBoundingBox.max);
    }

    public int hashCode() {
        return 29 * Arrays.hashCode(this.min) + Arrays.hashCode(this.max);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.getDimensionality();
        objectOutput.writeInt(n);
        for (double d : this.min) {
            objectOutput.writeDouble(d);
        }
        for (double d : this.max) {
            objectOutput.writeDouble(d);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2 = objectInput.readInt();
        this.min = new double[n2];
        this.max = new double[n2];
        for (n = 0; n < this.min.length; ++n) {
            this.min[n] = objectInput.readDouble();
        }
        for (n = 0; n < this.max.length; ++n) {
            this.max[n] = objectInput.readDouble();
        }
    }
}

