/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.bundle;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.ObjectBundle;
import de.lmu.ifi.dbs.elki.datasource.bundle.StreamFromBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

public class MultipleObjectsBundle
implements ObjectBundle {
    private static final Logging LOG = Logging.getLogger(MultipleObjectsBundle.class);
    private BundleMeta meta = new BundleMeta();
    private List<List<?>> columns = new ArrayList();
    private ArrayDBIDs ids;

    @Override
    public BundleMeta meta() {
        return this.meta;
    }

    @Override
    public SimpleTypeInformation<?> meta(int n) {
        return (SimpleTypeInformation)this.meta.get(n);
    }

    @Override
    public int metaLength() {
        return this.meta.size();
    }

    @Override
    public Object data(int n, int n2) {
        return this.columns.get(n2).get(n);
    }

    @Override
    public boolean assignDBID(int n, DBIDVar dBIDVar) {
        if (this.ids == null) {
            dBIDVar.unset();
            return false;
        }
        this.ids.assignVar(n, dBIDVar);
        return true;
    }

    @Override
    public int dataLength() {
        return this.ids != null ? this.ids.size() : (this.columns.size() == 0 ? 0 : this.columns.get(0).size());
    }

    public void appendSimple(Object ... objectArray) {
        if (objectArray.length != this.meta.size()) {
            throw new AbortException("Invalid number of attributes in 'append'.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            List<?> list = this.columns.get(i);
            list.add(objectArray[i]);
        }
    }

    public MultipleObjectsBundle appendColumn(SimpleTypeInformation<?> simpleTypeInformation, List<?> list) {
        this.meta.add(simpleTypeInformation);
        this.columns.add(list);
        return this;
    }

    public void setDBIDs(ArrayDBIDs arrayDBIDs) {
        this.ids = arrayDBIDs;
    }

    public ArrayDBIDs getDBIDs() {
        return this.ids;
    }

    public List<?> getColumn(int n) {
        return this.columns.get(n);
    }

    public static <V> MultipleObjectsBundle makeSimple(SimpleTypeInformation<? super V> simpleTypeInformation, List<? extends V> list) {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        multipleObjectsBundle.appendColumn(simpleTypeInformation, list);
        return multipleObjectsBundle;
    }

    public static <V1, V2> MultipleObjectsBundle makeSimple(SimpleTypeInformation<? super V1> simpleTypeInformation, List<? extends V1> list, SimpleTypeInformation<? super V2> simpleTypeInformation2, List<? extends V2> list2) {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        multipleObjectsBundle.appendColumn(simpleTypeInformation, list);
        multipleObjectsBundle.appendColumn(simpleTypeInformation2, list2);
        return multipleObjectsBundle;
    }

    public static <V1, V2, V3> MultipleObjectsBundle makeSimple(SimpleTypeInformation<? super V1> simpleTypeInformation, List<? extends V1> list, SimpleTypeInformation<? super V2> simpleTypeInformation2, List<? extends V2> list2, SimpleTypeInformation<? super V3> simpleTypeInformation3, List<? extends V3> list3) {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        multipleObjectsBundle.appendColumn(simpleTypeInformation, list);
        multipleObjectsBundle.appendColumn(simpleTypeInformation2, list2);
        multipleObjectsBundle.appendColumn(simpleTypeInformation3, list3);
        return multipleObjectsBundle;
    }

    public BundleStreamSource asStream() {
        return new StreamFromBundle(this);
    }

    public static MultipleObjectsBundle fromStream(BundleStreamSource bundleStreamSource) {
        MultipleObjectsBundle multipleObjectsBundle = new MultipleObjectsBundle();
        boolean bl = false;
        DBIDVar dBIDVar = null;
        DBIDs dBIDs = null;
        int n = 0;
        block5: while (!bl) {
            BundleStreamSource.Event event = bundleStreamSource.nextEvent();
            switch (event) {
                case END_OF_STREAM: {
                    bl = true;
                    continue block5;
                }
                case META_CHANGED: {
                    List<?> list;
                    int n2;
                    BundleMeta bundleMeta = bundleStreamSource.getMeta();
                    multipleObjectsBundle.meta = new BundleMeta();
                    for (n2 = 0; n2 < multipleObjectsBundle.columns.size(); ++n2) {
                        multipleObjectsBundle.meta.add(bundleMeta.get(n2));
                    }
                    for (n2 = multipleObjectsBundle.metaLength(); n2 < bundleMeta.size(); ++n2) {
                        list = new ArrayList(multipleObjectsBundle.dataLength() + 1);
                        multipleObjectsBundle.appendColumn((SimpleTypeInformation)bundleMeta.get(n2), list);
                    }
                    if (dBIDVar != null || !bundleStreamSource.hasDBIDs()) continue block5;
                    dBIDVar = DBIDUtil.newVar();
                    dBIDs = DBIDUtil.newArray();
                    continue block5;
                }
                case NEXT_OBJECT: {
                    List<?> list;
                    int n2;
                    if (dBIDVar != null && bundleStreamSource.assignDBID(dBIDVar)) {
                        dBIDs.add(dBIDVar);
                    }
                    for (n2 = 0; n2 < multipleObjectsBundle.metaLength(); ++n2) {
                        list = multipleObjectsBundle.columns.get(n2);
                        list.add(bundleStreamSource.data(n2));
                    }
                    ++n;
                    continue block5;
                }
            }
            LoggingUtil.warning("Unknown event: " + (Object)((Object)event));
        }
        if (dBIDs != null) {
            if (n != dBIDs.size()) {
                LOG.warning("Not every object had an DBID - discarding DBIDs: " + n + " != " + dBIDs.size());
            } else {
                multipleObjectsBundle.setDBIDs((ArrayDBIDs)dBIDs);
            }
        }
        return multipleObjectsBundle;
    }

    public Object[] getRow(int n) {
        Object[] objectArray = new Object[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            objectArray[i] = this.data(n, i);
        }
        return objectArray;
    }
}

