/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class SquaredPearsonCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final SquaredPearsonCorrelationDistanceFunction STATIC = new SquaredPearsonCorrelationDistanceFunction();

    @Deprecated
    public SquaredPearsonCorrelationDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        double d = MathUtil.pearsonCorrelationCoefficient(numberVector, numberVector2);
        return 1.0 - d * d;
    }

    public String toString() {
        return "SquaredPearsonCorrelationDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClass().equals(object.getClass());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SquaredPearsonCorrelationDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

