/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.external;

import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceCacheWriter;
import de.lmu.ifi.dbs.elki.distance.distancefunction.external.DistanceParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import java.io.IOException;
import java.io.InputStream;

@Title(value="Number Distance Parser")
@Description(value="Parser for the following line format:\nid1 id2 distanceValue, where id1 and is2 are integers starting at 0 representing the two ids belonging to the distance value.\nThe ids and the distance value are separated by whitespace. Empty lines and lines beginning with \"#\" will be ignored.")
@Alias(value={"de.lmu.ifi.dbs.elki.datasource.parser.NumberDistanceParser", "de.lmu.ifi.dbs.elki.distance.distancefunction.external.NumberDistanceParser", "de.lmu.ifi.dbs.elki.parser.NumberDistanceParser"})
public class AsciiDistanceParser
implements DistanceParser {
    private static final Logging LOG = Logging.getLogger(AsciiDistanceParser.class);
    protected TokenizedReader reader;
    protected Tokenizer tokenizer;

    public AsciiDistanceParser(CSVReaderFormat cSVReaderFormat) {
        this.reader = cSVReaderFormat.makeReader();
        this.tokenizer = this.reader.getTokenizer();
    }

    @Override
    public void parse(InputStream inputStream, DistanceCacheWriter distanceCacheWriter) {
        int n;
        int n2;
        this.reader.reset(inputStream);
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Parsing distance matrix", LOG) : null;
        try {
            while (this.reader.nextLineExceptComments()) {
                LOG.incrementProcessed(indefiniteProgress);
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    n2 = (int)this.tokenizer.getLongBase10();
                    this.tokenizer.advance();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ": id1 is not an integer!");
                }
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                try {
                    n = (int)this.tokenizer.getLongBase10();
                    this.tokenizer.advance();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ": id2 is not an integer!");
                }
                if (!this.tokenizer.valid()) {
                    throw new IllegalArgumentException("Less than three values in line " + this.reader.getLineNumber());
                }
                if (n2 < n) {
                    n3 = n2 < n3 ? n2 : n3;
                    n4 = n > n3 ? n : n4;
                } else {
                    n3 = n < n3 ? n : n3;
                    n4 = n2 > n3 ? n2 : n4;
                }
                try {
                    double d = this.tokenizer.getDouble();
                    distanceCacheWriter.put(n2, n, d);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Error in line " + this.reader.getLineNumber() + ":" + illegalArgumentException.getMessage(), illegalArgumentException);
                }
                this.tokenizer.advance();
                if (!this.tokenizer.valid()) continue;
                throw new IllegalArgumentException("More than three values in line " + this.reader.getLineNumber());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error while parsing line " + this.reader.getLineNumber() + ".");
        }
        LOG.setCompleted(indefiniteProgress);
        for (n2 = n3; n2 <= n4; ++n2) {
            for (n = n2 + 1; n <= n4; ++n) {
                if (distanceCacheWriter.containsKey(n2, n)) continue;
                throw new IllegalArgumentException("Distance value for " + n2 + " to " + n + " is missing!");
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected CSVReaderFormat format;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.format = (CSVReaderFormat)ClassGenericsUtil.parameterizeOrAbort(CSVReaderFormat.class, parameterization);
        }

        @Override
        protected AsciiDistanceParser makeInstance() {
            return new AsciiDistanceParser(this.format);
        }
    }
}

