/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="Meil\u0103, M.", title="Comparing clusterings by the variation of information", booktitle="Learning theory and kernel machines", url="http://dx.doi.org/10.1007/978-3-540-45167-9_14")
public class Entropy {
    protected double entropyFirst = -1.0;
    protected double entropySecond = -1.0;
    protected double entropyJoint = -1.0;

    protected Entropy(ClusterContingencyTable clusterContingencyTable) {
        double d;
        int n;
        double d2 = 1.0 / (double)clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2];
        this.entropyFirst = 0.0;
        for (n = 0; n < clusterContingencyTable.size1; ++n) {
            if (clusterContingencyTable.contingency[n][clusterContingencyTable.size2] <= 0) continue;
            d = d2 * (double)clusterContingencyTable.contingency[n][clusterContingencyTable.size2];
            this.entropyFirst -= d * Math.log(d);
        }
        this.entropySecond = 0.0;
        for (n = 0; n < clusterContingencyTable.size2; ++n) {
            if (clusterContingencyTable.contingency[clusterContingencyTable.size1][n] <= 0) continue;
            d = d2 * (double)clusterContingencyTable.contingency[clusterContingencyTable.size1][n];
            this.entropySecond -= d * Math.log(d);
        }
        this.entropyJoint = 0.0;
        for (n = 0; n < clusterContingencyTable.size1; ++n) {
            for (int i = 0; i < clusterContingencyTable.size2; ++i) {
                if (clusterContingencyTable.contingency[n][i] <= 0) continue;
                double d3 = d2 * (double)clusterContingencyTable.contingency[n][i];
                this.entropyJoint -= d3 * Math.log(d3);
            }
        }
    }

    public double entropyFirst() {
        return this.entropyFirst;
    }

    public double entropySecond() {
        return this.entropySecond;
    }

    public double entropyJoint() {
        return this.entropyJoint;
    }

    public double entropyConditionalFirst() {
        return this.entropyJoint() - this.entropySecond();
    }

    public double entropyConditionalSecond() {
        return this.entropyJoint() - this.entropyFirst();
    }

    public double entropyPowers() {
        return 2.0 * this.entropyJoint() / (this.entropyFirst() + this.entropySecond()) - 1.0;
    }

    public double entropyMutualInformation() {
        return this.entropyFirst() + this.entropySecond() - this.entropyJoint();
    }

    public double entropyNMIJoint() {
        if (this.entropyJoint() == 0.0) {
            return 0.0;
        }
        return this.entropyMutualInformation() / this.entropyJoint();
    }

    public double entropyNMIMin() {
        return this.entropyMutualInformation() / Math.min(this.entropyFirst(), this.entropySecond());
    }

    public double entropyNMIMax() {
        return this.entropyMutualInformation() / Math.max(this.entropyFirst(), this.entropySecond());
    }

    public double entropyNMISum() {
        return 2.0 * this.entropyMutualInformation() / (this.entropyFirst() + this.entropySecond());
    }

    public double entropyNMISqrt() {
        if (this.entropyFirst() * this.entropySecond() <= 0.0) {
            return this.entropyMutualInformation();
        }
        return this.entropyMutualInformation() / Math.sqrt(this.entropyFirst() * this.entropySecond());
    }

    public double variationOfInformation() {
        return 2.0 * this.entropyJoint() - (this.entropyFirst() + this.entropySecond());
    }

    @Reference(authors="Nguyen, X. V. and Epps, J. and Bailey, J.", title="Information theoretic measures for clusterings comparison: is a correction for chance necessary?", booktitle="Proc. ICML '09 Proceedings of the 26th Annual International Conference on Machine Learning", url="http://dx.doi.org/10.1145/1553374.1553511")
    public double normalizedVariationOfInformation() {
        return 1.0 - this.entropyMutualInformation() / this.entropyJoint();
    }
}

