/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.SpatialDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPointLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.AbstractRTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat.FlatRStarTree;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.flat.FlatRStarTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.query.RStarTreeUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.ArrayList;
import java.util.List;

public class FlatRStarTreeIndex<O extends NumberVector>
extends FlatRStarTree
implements RangeIndex<O>,
KNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    private static final Logging LOG = Logging.getLogger(FlatRStarTreeIndex.class);

    public FlatRStarTreeIndex(Relation<O> relation, PageFile<FlatRStarTreeNode> pageFile, AbstractRTreeSettings abstractRTreeSettings) {
        super(pageFile, abstractRTreeSettings);
        this.relation = relation;
    }

    protected SpatialEntry createNewLeafEntry(DBID dBID) {
        return new SpatialPointLeafEntry(dBID, (NumberVector)this.relation.get(dBID));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public final void insert(DBIDRef dBIDRef) {
        this.insertLeaf(this.createNewLeafEntry(DBIDUtil.deref(dBIDRef)));
    }

    @Override
    public final void insertAll(DBIDs dBIDs) {
        if (dBIDs.isEmpty() || dBIDs.size() == 1) {
            return;
        }
        if (this.canBulkLoad()) {
            ArrayList<SpatialEntry> arrayList = new ArrayList<SpatialEntry>(dBIDs.size());
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                arrayList.add(this.createNewLeafEntry(DBIDUtil.deref(dBIDIter)));
                dBIDIter.advance();
            }
            this.bulkLoad((List<SpatialEntry>)arrayList);
        } else {
            DBIDIter dBIDIter = dBIDs.iter();
            while (dBIDIter.valid()) {
                this.insert(dBIDIter);
                dBIDIter.advance();
            }
        }
        this.doExtraIntegrityChecks();
    }

    @Override
    public final boolean delete(DBIDRef dBIDRef) {
        NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
        IndexTreePath indexTreePath = this.findPathToObject(this.getRootPath(), numberVector, dBIDRef);
        if (indexTreePath == null) {
            return false;
        }
        this.deletePath(indexTreePath);
        return true;
    }

    @Override
    public void deleteAll(DBIDs dBIDs) {
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            this.delete(DBIDUtil.deref(dBIDIter));
            dBIDIter.advance();
        }
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery spatialDistanceQuery = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getRangeQuery(this, spatialDistanceQuery, objectArray);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        if (!(distanceQuery instanceof SpatialDistanceQuery)) {
            return null;
        }
        SpatialDistanceQuery spatialDistanceQuery = (SpatialDistanceQuery)distanceQuery;
        return RStarTreeUtil.getKNNQuery(this, spatialDistanceQuery, objectArray);
    }

    @Override
    public String getLongName() {
        return "Flat R*-Tree";
    }

    @Override
    public String getShortName() {
        return "flatrstartree";
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

