/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.scales;

import java.text.NumberFormat;
import java.util.Locale;

public class LinearScale {
    private final double ZOOMFACTOR = Math.log10(31.0);
    private double min;
    private double max;
    private double res;
    private int log10res;
    private double delta;

    public LinearScale(double d, double d2) {
        if (d2 < d) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        this.delta = d2 - d;
        if (this.delta <= Double.MIN_NORMAL) {
            this.delta = 1.0;
        }
        this.log10res = (int)Math.ceil(Math.log10(this.delta) - this.ZOOMFACTOR);
        this.res = Math.pow(10.0, this.log10res);
        this.min = Math.floor(d / this.res) * this.res;
        this.max = Math.ceil(d2 / this.res) * this.res;
        if (this.min == this.max) {
            this.max = this.min + this.res;
        }
        this.delta = this.max - this.min;
        if (this.delta <= Double.MIN_NORMAL) {
            this.delta = 1.0;
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getRes() {
        return this.res;
    }

    public double getLog10Res() {
        return this.log10res;
    }

    public double getScaled(double d) {
        return (d - this.min) / this.delta;
    }

    public double getUnscaled(double d) {
        return d * this.delta + this.min;
    }

    public double getRelativeScaled(double d) {
        return d / this.delta;
    }

    public double getRelativeUnscaled(double d) {
        return d * this.delta;
    }

    public double getScaled(double d, double d2, double d3) {
        return this.getScaled(d) * (d3 - d2) + d2;
    }

    public double getUnscaled(double d, double d2, double d3) {
        return this.getUnscaled(d) * (d3 - d2) + d2;
    }

    public double getRelativeScaled(double d, double d2, double d3) {
        return this.getRelativeScaled(d) * (d2 - d3);
    }

    public double getRelativeUnscaled(double d, double d2, double d3) {
        return this.getRelativeUnscaled(d) * (d3 - d2);
    }

    public String formatValue(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(-this.log10res);
        return numberFormat.format(d);
    }
}

