/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.statistics.MultipleLinearRegression;

public class PolynomialRegression
extends MultipleLinearRegression {
    public final int p;

    public PolynomialRegression(Vector vector, Vector vector2, int n) {
        super(vector, PolynomialRegression.xMatrix(vector2, n));
        this.p = n;
    }

    private static Matrix xMatrix(Vector vector, int n) {
        int n2 = vector.getDimensionality();
        Matrix matrix = new Matrix(n2, n + 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                matrix.set(i, j, MathUtil.powi(vector.get(i), j));
            }
        }
        return matrix;
    }

    public double adaptedCoefficientOfDetermination() {
        int n = this.getEstimatedResiduals().getDimensionality();
        return 1.0 - ((double)n - 1.0) / ((double)n * 1.0 - (double)this.p) * (1.0 - this.coefficientOfDetermination());
    }

    public double estimateY(double d) {
        return super.estimateY(PolynomialRegression.xMatrix(new Vector(d), this.p));
    }
}

