/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.MADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;

public abstract class AbstractMADEstimator<D extends Distribution>
implements MADDistributionEstimator<D> {
    @Override
    public abstract D estimateFromMedianMAD(double var1, double var3);

    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberArrayAdapter.getDouble(a, i);
        }
        double d = QuickSelect.median(dArray);
        double d2 = AbstractMADEstimator.computeMAD(dArray, d);
        return this.estimateFromMedianMAD(d, d2);
    }

    public static double computeMAD(double[] dArray, double d) {
        double d2;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.abs(dArray[i] - d);
        }
        double d3 = QuickSelect.median(dArray);
        if (!(d3 > 0.0)) {
            d2 = Double.POSITIVE_INFINITY;
            for (double d4 : dArray) {
                if (!(d4 > 0.0) || !(d4 < d2)) continue;
                d2 = d4;
            }
            d3 = d2 < Double.POSITIVE_INFINITY ? d2 : 1.0;
        }
        if (d3 == Double.POSITIVE_INFINITY) {
            d2 = 0.0;
            for (double d4 : dArray) {
                if (!(d4 < Double.POSITIVE_INFINITY) || !(d4 > d2)) continue;
                d2 = d4;
            }
            d3 = d2 < Double.POSITIVE_INFINITY ? d2 : 1.0;
        }
        return d3;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

