/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LaplaceDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.DistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(title="The Double Exponential Distribution: Using Calculus to Find a Maximum Likelihood Estimator", authors="R. M. Norton", booktitle="The American Statistician 38 (2)", url="http://dx.doi.org/10.2307/2683252")
public class LaplaceMLEEstimator
implements DistributionEstimator<LaplaceDistribution> {
    public static final LaplaceMLEEstimator STATIC = new LaplaceMLEEstimator();

    private LaplaceMLEEstimator() {
    }

    @Override
    public <A> LaplaceDistribution estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberArrayAdapter.getDouble(a, i);
        }
        double d = QuickSelect.median(dArray);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d2 += Math.abs(dArray[i] - d);
        }
        return new LaplaceDistribution((double)n / d2, d);
    }

    @Override
    public Class<? super LaplaceDistribution> getDistributionClass() {
        return LaplaceDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LaplaceMLEEstimator makeInstance() {
            return STATIC;
        }
    }
}

