/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.SkewGeneralizedNormalDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking", title="Fortran routines for use with the method of L-moments Version 3.03", booktitle="IBM Research Technical Report")
public class SkewGNormalLMMEstimator
extends AbstractLMMEstimator<SkewGeneralizedNormalDistribution> {
    public static final SkewGNormalLMMEstimator STATIC = new SkewGNormalLMMEstimator();
    private static final double A0 = 2.0466534;
    private static final double A1 = -3.6544371;
    private static final double A2 = 1.8396733;
    private static final double A3 = -0.20360244;
    private static final double B1 = -2.0182173;
    private static final double B2 = 1.2420401;
    private static final double B3 = -0.21741801;

    private SkewGNormalLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public SkewGeneralizedNormalDistribution estimateFromLMoments(double[] dArray) {
        double d;
        double d2;
        double d3;
        if (!(dArray[1] > 0.0) || !(Math.abs(dArray[2]) < 1.0)) {
            throw new ArithmeticException("L-Moments invalid");
        }
        double d4 = dArray[2];
        if (Math.abs(d4) >= 0.95) {
            d3 = 0.0;
            d2 = -1.0;
            d = 0.0;
        } else if (Math.abs(d4) <= 1.0E-8) {
            d3 = dArray[0];
            d2 = dArray[1] * MathUtil.SQRTPI;
            d = 0.0;
        } else {
            double d5 = d4 * d4;
            d = -d4 * (2.0466534 + d5 * (-3.6544371 + d5 * (1.8396733 + d5 * -0.20360244))) / (1.0 + d5 * (-2.0182173 + d5 * (1.2420401 + d5 * -0.21741801)));
            double d6 = Math.exp(0.5 * d * d);
            d2 = dArray[1] * d / (d6 * NormalDistribution.erf(0.5 * d));
            d3 = dArray[0] + d2 * (d6 - 1.0) / d;
        }
        return new SkewGeneralizedNormalDistribution(d3, d2, d);
    }

    @Override
    public Class<? super SkewGeneralizedNormalDistribution> getDistributionClass() {
        return SkewGeneralizedNormalDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SkewGNormalLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

