/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="L. Amsaleg and O. Chelly and T. Furon and S. Girard and M. E. Houle and K. Kawarabayashi and M. Nett", title="Estimating Local Intrinsic Dimensionality", booktitle="Proc. SIGKDD International Conference on Knowledge Discovery and Data Mining 2015", url="http://dx.doi.org/10.1145/2783258.2783405")
public class RVEstimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final RVEstimator STATIC = new RVEstimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        int n2 = n >> 1;
        int n3 = 3 * n >> 2;
        int n4 = n;
        double d = numberArrayAdapter.getDouble(a, n2 - 1);
        double d2 = numberArrayAdapter.getDouble(a, n3 - 1);
        double d3 = numberArrayAdapter.getDouble(a, n4 - 1);
        double d4 = (d3 - d2) / (d - 2.0 * d2 + d3);
        double d5 = (1.0 - d4) / d4;
        return (Math.log((double)n4 / (double)n3) + d5 * Math.log((double)n2 / (double)n3)) / (Math.log(d3 / d2) + d5 * Math.log(d / d2));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RVEstimator makeInstance() {
            return STATIC;
        }
    }
}

