/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.parallel.processor;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedObject;

public class KNNProcessor<O>
implements Processor {
    int k;
    KNNQuery<O> knnq;
    SharedObject<KNNList> out;

    public KNNProcessor(int n, KNNQuery<O> kNNQuery) {
        this.k = n;
        this.knnq = kNNQuery;
    }

    public void connectKNNOutput(SharedObject<KNNList> sharedObject) {
        this.out = sharedObject;
    }

    @Override
    public Instance<O> instantiate(Executor executor) {
        return new Instance<O>(this.k, this.knnq, (SharedObject.Instance)((Object)executor.getInstance(this.out)));
    }

    @Override
    public void cleanup(Processor.Instance instance) {
    }

    public static class Instance<O>
    implements Processor.Instance {
        int k;
        KNNQuery<O> knnq;
        SharedObject.Instance<KNNList> out;

        protected Instance(int n, KNNQuery<O> kNNQuery, SharedObject.Instance<KNNList> instance) {
            this.k = n;
            this.knnq = kNNQuery;
            this.out = instance;
        }

        @Override
        public void map(DBIDRef dBIDRef) {
            this.out.set(this.knnq.getKNNForDBID(dBIDRef, this.k));
        }
    }
}

