/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.InternalParameterizationErrors;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrackParameters
implements Parameterization {
    Parameterization inner;
    List<TrackedParameter> options = new ArrayList<TrackedParameter>();
    Map<Object, Object> parents = new HashMap<Object, Object>();
    Map<Object, List<Object>> children = new HashMap<Object, List<Object>>();
    Object owner = null;

    public TrackParameters(Parameterization parameterization) {
        this.inner = parameterization;
    }

    public TrackParameters(Parameterization parameterization, Object object) {
        this.inner = parameterization;
        this.owner = object;
    }

    private TrackParameters(Parameterization parameterization, Object object, List<TrackedParameter> list, Map<Object, Object> map, Map<Object, List<Object>> map2) {
        this.inner = parameterization.descend(object);
        this.owner = object;
        this.options = list;
        this.parents = map;
        this.children = map2;
    }

    @Override
    public Collection<ParameterException> getErrors() {
        return this.inner.getErrors();
    }

    @Override
    public boolean hasErrors() {
        return this.inner.hasErrors();
    }

    @Override
    public boolean grab(Parameter<?> parameter) {
        this.registerChild(parameter);
        this.options.add(new TrackedParameter(this.owner, parameter));
        return this.inner.grab(parameter);
    }

    @Override
    public boolean hasUnusedParameters() {
        return this.inner.hasUnusedParameters();
    }

    @Override
    public void reportError(ParameterException parameterException) {
        this.inner.reportError(parameterException);
    }

    @Override
    public boolean setValueForOption(Parameter<?> parameter) throws ParameterException {
        this.registerChild(parameter);
        this.options.add(new TrackedParameter(this.owner, parameter));
        return this.inner.setValueForOption(parameter);
    }

    public Collection<TrackedParameter> getAllParameters() {
        return this.options;
    }

    @Override
    public boolean checkConstraint(GlobalParameterConstraint globalParameterConstraint) {
        return this.inner.checkConstraint(globalParameterConstraint);
    }

    @Override
    public Parameterization descend(Object object) {
        this.registerChild(object);
        return new TrackParameters(this.inner, object, this.options, this.parents, this.children);
    }

    private void registerChild(Object object) {
        if (object == this.owner) {
            LoggingUtil.exception("Options shouldn't have themselves as parents!", new Throwable());
        }
        this.parents.put(object, this.owner);
        List<Object> list = this.children.get(this.owner);
        if (list == null) {
            list = new ArrayList<Object>();
            this.children.put(this.owner, list);
        }
        if (!list.contains(object)) {
            list.add(object);
        }
    }

    public Object getParent(Object object) {
        return this.parents.get(object);
    }

    @Override
    public <C> C tryInstantiate(Class<C> clazz, Class<?> clazz2) {
        try {
            return ClassGenericsUtil.tryInstantiate(clazz, clazz2, this);
        }
        catch (Exception exception) {
            this.reportError(new InternalParameterizationErrors("Error instantiating internal class: " + clazz2.getName(), exception));
            return null;
        }
    }

    @Override
    public <C> C tryInstantiate(Class<C> clazz) {
        try {
            return ClassGenericsUtil.tryInstantiate(clazz, clazz, this);
        }
        catch (Exception exception) {
            this.reportError(new InternalParameterizationErrors("Error instantiating internal class: " + clazz.getName(), exception));
            return null;
        }
    }
}

