/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.batikutil;

import de.lmu.ifi.dbs.elki.logging.Logging;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.RedRable;
import org.apache.batik.ext.awt.image.spi.AbstractRegistryEntry;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.URLRegistryEntry;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLData;
import org.apache.batik.util.ParsedURLProtocolHandler;

public class ThumbnailRegistryEntry
extends AbstractRegistryEntry
implements URLRegistryEntry,
ParsedURLProtocolHandler {
    public static final String INTERNAL_PROTOCOL = "thumb";
    public static final String INTERNAL_PREFIX = "thumb:";
    public static final String INTERNAL_MIME_TYPE = "internal/thumb";
    public static final float PRIORITY = 1000.0f;
    private static final Logging LOG = Logging.getLogger(ThumbnailRegistryEntry.class);
    private static final TIntObjectMap<SoftReference<RenderedImage>> images = new TIntObjectHashMap<SoftReference<RenderedImage>>();
    private static int counter = 1;

    public ThumbnailRegistryEntry() {
        super("Internal", 1000.0f, new String[0], new String[]{INTERNAL_MIME_TYPE});
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("Registry initialized.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerImage(RenderedImage renderedImage) {
        TIntObjectMap<SoftReference<RenderedImage>> tIntObjectMap = images;
        synchronized (tIntObjectMap) {
            int n = counter++;
            assert (images.get(n) == null);
            images.put(n, new SoftReference<RenderedImage>(renderedImage));
            if (counter % 50 == 49) {
                TIntObjectIterator<SoftReference<RenderedImage>> tIntObjectIterator = images.iterator();
                while (tIntObjectIterator.hasNext()) {
                    tIntObjectIterator.advance();
                    if (tIntObjectIterator.value() != null && tIntObjectIterator.value().get() != null) continue;
                    tIntObjectIterator.remove();
                }
            }
            if (LOG.isDebuggingFiner()) {
                LOG.debugFiner("Registered image: " + n);
            }
            return n;
        }
    }

    @Override
    public boolean isCompatibleURL(ParsedURL parsedURL) {
        return ThumbnailRegistryEntry.isCompatibleURLStatic(parsedURL);
    }

    public static boolean isCompatibleURLStatic(ParsedURL parsedURL) {
        return parsedURL.getProtocol().equals(INTERNAL_PROTOCOL);
    }

    @Override
    public Filter handleURL(ParsedURL parsedURL, boolean bl) {
        Filter filter = ThumbnailRegistryEntry.handleURL(parsedURL);
        if (filter != null) {
            return filter;
        }
        return ImageTagRegistry.getBrokenLinkImage(this, "imageDir does not exist", new Object[0]);
    }

    public static Filter handleURL(ParsedURL parsedURL) {
        int n;
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("handleURL " + parsedURL.toString());
        }
        if (!ThumbnailRegistryEntry.isCompatibleURLStatic(parsedURL)) {
            return null;
        }
        try {
            n = Integer.parseInt(parsedURL.getPath());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        SoftReference<RenderedImage> softReference = images.get(n);
        if (softReference != null) {
            RenderedImage renderedImage = softReference.get();
            if (renderedImage == null) {
                LOG.warning("Referenced image has expired from the cache!");
            } else {
                return new RedRable(GraphicsUtil.wrap(renderedImage));
            }
        }
        return null;
    }

    @Override
    public ParsedURLData parseURL(String string) {
        if (LOG.isDebuggingFinest()) {
            LOG.debugFinest("parseURL: " + string);
        }
        if (string.startsWith(INTERNAL_PREFIX)) {
            InternalParsedURLData internalParsedURLData = new InternalParsedURLData(string.substring(INTERNAL_PREFIX.length()));
            return internalParsedURLData;
        }
        return null;
    }

    @Override
    public ParsedURLData parseURL(ParsedURL parsedURL, String string) {
        return this.parseURL(string);
    }

    @Override
    public String getProtocolHandled() {
        return INTERNAL_PROTOCOL;
    }

    class InternalParsedURLData
    extends ParsedURLData {
        public InternalParsedURLData(String string) {
            this.protocol = ThumbnailRegistryEntry.INTERNAL_PROTOCOL;
            this.contentType = ThumbnailRegistryEntry.INTERNAL_MIME_TYPE;
            this.path = string;
        }

        @Override
        public String getContentType(String string) {
            return ThumbnailRegistryEntry.INTERNAL_MIME_TYPE;
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public InputStream openStream(String string, Iterator iterator) throws IOException {
            return null;
        }
    }
}

