/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style.marker;

import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import org.w3c.dom.Element;

public class PrettyMarkers
implements MarkerLibrary {
    private ColorLibrary colors;
    private static final String DEFAULT_PREFIX = "s";
    private String prefix;
    private String dotcolor;
    private String greycolor;

    public PrettyMarkers(String string, StyleLibrary styleLibrary) {
        this.prefix = string;
        this.colors = styleLibrary.getColorSet("plot.marker");
        this.dotcolor = styleLibrary.getColor("plot.marker");
        this.greycolor = styleLibrary.getColor("plot.grey");
    }

    public PrettyMarkers(StyleLibrary styleLibrary) {
        this(DEFAULT_PREFIX, styleLibrary);
    }

    public void plotMarker(SVGPlot sVGPlot, Element element, double d, double d2, int n, double d3) {
        assert (element != null);
        if (n == -1) {
            this.plotUncolored(sVGPlot, element, d, d2, d3);
            return;
        }
        if (n == -2) {
            this.plotGray(sVGPlot, element, d, d2, d3);
            return;
        }
        String string = this.colors.getColor(n);
        String string2 = "stroke:" + string + ";" + "stroke-width" + ":" + SVGUtil.fmt(d3 / 6.0);
        switch (n % 8) {
            case 0: {
                Element element2 = sVGPlot.svgLine(d, d2 - d3 / 2.2, d, d2 + d3 / 2.2);
                SVGUtil.setStyle(element2, string2);
                element.appendChild(element2);
                Element element3 = sVGPlot.svgLine(d - d3 / 2.2, d2, d + d3 / 2.2, d2);
                SVGUtil.setStyle(element3, string2);
                element.appendChild(element3);
                break;
            }
            case 1: {
                Element element4 = sVGPlot.svgLine(d - d3 / 2.828427, d2 - d3 / 2.828427, d + d3 / 2.828427, d2 + d3 / 2.828427);
                SVGUtil.setStyle(element4, string2);
                element.appendChild(element4);
                Element element5 = sVGPlot.svgLine(d - d3 / 2.828427, d2 + d3 / 2.828427, d + d3 / 2.828427, d2 - d3 / 2.828427);
                SVGUtil.setStyle(element5, string2);
                element.appendChild(element5);
                break;
            }
            case 2: {
                Element element6 = sVGPlot.svgCircle(d, d2, d3 / 2.2);
                SVGUtil.setStyle(element6, "fill: none;" + string2);
                element.appendChild(element6);
                break;
            }
            case 3: {
                Element element7 = sVGPlot.svgRect(d - d3 / 2.4, d2 - d3 / 2.4, d3 / 1.2, d3 / 1.2);
                SVGUtil.setStyle(element7, "fill: none;" + string2);
                element.appendChild(element7);
                break;
            }
            case 4: {
                Element element8 = sVGPlot.svgRect(d - d3 / 2.7, d2 - d3 / 2.7, d3 / 1.35, d3 / 1.35);
                SVGUtil.setStyle(element8, "fill: none;" + string2);
                SVGUtil.setAtt(element8, "transform", "rotate(45," + SVGUtil.fmt(d) + "," + SVGUtil.fmt(d2) + ")");
                element.appendChild(element8);
                break;
            }
            case 5: {
                Element element9 = sVGPlot.svgCircle(d, d2, d3 * 0.5);
                SVGUtil.setStyle(element9, "fill:" + string);
                element.appendChild(element9);
                break;
            }
            case 6: {
                Element element10 = sVGPlot.svgRect(d - d3 / 2.2, d2 - d3 / 2.2, d3 / 1.1, d3 / 1.1);
                SVGUtil.setStyle(element10, "fill:" + string);
                element.appendChild(element10);
                break;
            }
            case 7: {
                Element element11 = sVGPlot.svgRect(d - d3 / 2.5, d2 - d3 / 2.5, d3 / 1.25, d3 / 1.25);
                SVGUtil.setStyle(element11, "fill:" + string);
                SVGUtil.setAtt(element11, "transform", "rotate(45," + SVGUtil.fmt(d) + "," + SVGUtil.fmt(d2) + ")");
                element.appendChild(element11);
                break;
            }
        }
    }

    protected void plotGray(SVGPlot sVGPlot, Element element, double d, double d2, double d3) {
        Element element2 = sVGPlot.svgCircle(d, d2, d3 * 0.5);
        SVGUtil.setStyle(element2, "fill:" + this.greycolor);
        element.appendChild(element2);
    }

    protected void plotUncolored(SVGPlot sVGPlot, Element element, double d, double d2, double d3) {
        Element element2 = sVGPlot.svgCircle(d, d2, d3 * 0.5);
        SVGUtil.setStyle(element2, "fill:" + this.dotcolor);
        element.appendChild(element2);
    }

    @Override
    public Element useMarker(SVGPlot sVGPlot, Element element, double d, double d2, int n, double d3) {
        Element element2;
        String string = this.prefix + n + "_" + d3;
        Element element3 = sVGPlot.getIdElement(string);
        if (element3 == null) {
            element2 = sVGPlot.svgElement("symbol");
            SVGUtil.setAtt(element2, "id", string);
            this.plotMarker(sVGPlot, element2, 2.0 * d3, 2.0 * d3, n, 2.0 * d3);
            sVGPlot.getDefs().appendChild(element2);
            sVGPlot.putIdElement(string, element2);
        }
        element2 = sVGPlot.svgElement("use");
        element2.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "#" + string);
        SVGUtil.setAtt(element2, "x", d - 2.0 * d3);
        SVGUtil.setAtt(element2, "y", d2 - 2.0 * d3);
        if (element != null) {
            element.appendChild(element2);
        }
        return element2;
    }
}

