/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.MeanModel;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ClusterStarVisualization
extends AbstractVisFactory {
    private static final String NAME = "Cluster Stars";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, relation, this);
                visualizationTask.level = 101;
                visualizationTask.addUpdateFlags(4);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        private static final String CSS_MEAN_STAR = "mean-star";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)stylingPolicy).getClustering();
            if (clustering.getAllClusters().size() == 0) {
                return;
            }
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            ColorLibrary colorLibrary = styleLibrary.getColorSet("plot");
            Iterator<Cluster<?>> iterator = clustering.getAllClusters().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                block10: {
                    double[] dArray;
                    Object object;
                    Cluster<?> cluster;
                    block9: {
                        Object obj;
                        block8: {
                            cluster = iterator.next();
                            obj = cluster.getModel();
                            if (!(obj instanceof MeanModel)) break block8;
                            object = (MeanModel)obj;
                            dArray = this.proj.fastProjectDataToRenderSpace(((MeanModel)object).getMean());
                            break block9;
                        }
                        if (!(obj instanceof MedoidModel)) break block10;
                        object = (MedoidModel)obj;
                        dArray = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(((MedoidModel)object).getMedoid()));
                    }
                    if (!this.svgp.getCSSClassManager().contains("mean-star_" + n)) {
                        object = new CSSClass(this, "mean-star_" + n);
                        ((CSSClass)object).setStatement("stroke", colorLibrary.getColor(n));
                        ((CSSClass)object).setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                        ((CSSClass)object).setStatement("opacity", "0.7");
                        this.svgp.addCSSClassOrLogError((CSSClass)object);
                    }
                    object = new SVGPath();
                    Object object2 = cluster.getIDs().iter();
                    while (object2.valid()) {
                        double[] dArray2 = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get((DBIDRef)object2));
                        ((SVGPath)object).moveTo(dArray2);
                        ((SVGPath)object).drawTo(dArray);
                        object2.advance();
                    }
                    object2 = ((SVGPath)object).makeElement(this.svgp);
                    SVGUtil.setCSSClass((Element)object2, "mean-star_" + n);
                    this.layer.appendChild((Node)object2);
                }
                ++n;
            }
            this.svgp.updateStyleElement();
        }
    }
}

