/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class FileUtil {
    public static void setFileContents(String str, File file) throws Exception {
        FileWriter writer = new FileWriter(file);
        writer.append(str);
        writer.flush();
        writer.close();
    }

    public static String replaceExtension(String filename, String newExtension) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > -1) {
            filename = String.valueOf(filename.substring(0, dotIndex + 1)) + newExtension;
        }
        return filename;
    }

    public static String removeExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > -1) {
            filename = filename.substring(0, dotIndex);
        }
        return filename;
    }

    public static String getFileContents(File file) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        for (String line : FileUtil.getFileLineContents(file)) {
            buffer.append(line);
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public static Collection<String> getFileLineContents(File file) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            LinkedList<String> lines = new LinkedList<String>();
            String line = bufferedReader.readLine();
            while (line != null) {
                lines.add(line);
                line = bufferedReader.readLine();
            }
            LinkedList<String> linkedList = lines;
            return linkedList;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static String getAbsolutePath(String basePath, String relativePath) {
        File file = new File(relativePath);
        if (!file.isAbsolute()) {
            file = new File(basePath, relativePath);
        }
        return file.getAbsolutePath();
    }

    public static File getFile(String name, Class<?> relativeTo) {
        try {
            File clazz = new File(URLDecoder.decode(relativeTo.getResource(String.valueOf(relativeTo.getSimpleName()) + ".class").getFile(), "UTF-8"));
            return new File(clazz.getParentFile(), name);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(String.valueOf(name) + " could not be located relative to " + relativeTo);
        }
    }

    public static File getDirectoryOf(Class<?> clazz) {
        return FileUtil.getFile(String.valueOf(clazz.getSimpleName()) + ".class", clazz).getParentFile();
    }

    public static String getPath(String name, Class<?> relativeTo) {
        return FileUtil.getFile(name, relativeTo).getAbsolutePath();
    }

    public static void checkFileExists(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException("File " + file.getPath() + " does not exist");
        }
    }

    public static File copyToTemp(File srcFile) throws IOException {
        File tmpFile = File.createTempFile("filecompare", "tmp");
        if (srcFile.isDirectory()) {
            tmpFile.delete();
            tmpFile.mkdir();
        }
        FileUtil.copy(srcFile, tmpFile);
        return tmpFile;
    }

    public static void copy(File srcFile, File dstFile) throws IOException {
        if (srcFile.isDirectory()) {
            dstFile.mkdir();
            File[] fileArray = srcFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                FileUtil.copy(entry, new File(dstFile, entry.getName()));
                ++n2;
            }
        } else {
            FileInputStream isSrc = null;
            FileOutputStream osDst = null;
            AbstractInterruptibleChannel chSrc = null;
            AbstractInterruptibleChannel chDst = null;
            try {
                isSrc = new FileInputStream(srcFile);
                osDst = new FileOutputStream(dstFile);
                chSrc = isSrc.getChannel();
                chDst = osDst.getChannel();
                long srcBytes = srcFile.length();
                long transferred = 0L;
                while (transferred < srcBytes) {
                    transferred += ((FileChannel)chDst).transferFrom((ReadableByteChannel)((Object)chSrc), transferred, srcBytes);
                    ((FileChannel)chDst).position(transferred);
                }
            }
            finally {
                if (chDst != null) {
                    chDst.close();
                } else if (osDst != null) {
                    osDst.close();
                }
                if (chSrc != null) {
                    chSrc.close();
                } else if (isSrc != null) {
                    isSrc.close();
                }
            }
        }
    }

    public static HashSet<String> listFilesAsSet(File fileExpected) {
        return new HashSet<String>(Arrays.asList(fileExpected.list()));
    }

    public static boolean sameContents(File fileExpected, File fileActual, Set<String> ignoreFilenames) throws IOException {
        if (fileExpected.isDirectory() != fileActual.isDirectory()) {
            return false;
        }
        if (fileExpected.isDirectory()) {
            HashSet<String> expectedFilenames = FileUtil.listFilesAsSet(fileExpected);
            HashSet<String> actualFilenames = FileUtil.listFilesAsSet(fileActual);
            expectedFilenames.removeAll(ignoreFilenames);
            actualFilenames.removeAll(ignoreFilenames);
            if (!expectedFilenames.equals(actualFilenames)) {
                return false;
            }
            for (String filename : expectedFilenames) {
                File actualEntry;
                File expectedEntry = new File(fileExpected, filename);
                if (FileUtil.sameContents(expectedEntry, actualEntry = new File(fileActual, filename), ignoreFilenames)) continue;
                return false;
            }
            return true;
        }
        if (fileExpected.length() != fileActual.length()) {
            return false;
        }
        FileInputStream isExpected = new FileInputStream(fileExpected);
        try {
            boolean bl;
            FileInputStream isActual = new FileInputStream(fileActual);
            try {
                bl = FileUtil.sameContents(isExpected, isActual);
            }
            catch (Throwable throwable) {
                isActual.close();
                throw throwable;
            }
            isActual.close();
            return bl;
        }
        finally {
            isExpected.close();
        }
    }

    public static boolean sameContents(InputStream isExpected, InputStream isActual) throws IOException {
        int chActual;
        int chExpected;
        while ((chExpected = isExpected.read()) == (chActual = isActual.read()) && chExpected > 0 && chActual > 0) {
        }
        return chExpected == chActual;
    }
}

