/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.preprocessor;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epsilon.egl.util.FileUtil;

public class PreprocessorTrace {
    private Map<Integer, Integer> lineNumberMapping = new TreeMap<Integer, Integer>();
    private Map<Integer, Integer> columnCorrections = new TreeMap<Integer, Integer>();
    private int currentEolLine = 1;
    private int maximumEglLineNumber = 1;

    public int getEglLineNumberFor(int eolLine) {
        if (this.lineNumberMapping.containsKey(eolLine)) {
            return this.lineNumberMapping.get(eolLine);
        }
        return this.maximumEglLineNumber;
    }

    public int getEglColumnNumberFor(int eolLine, int eolCol) {
        if (this.columnCorrections.containsKey(eolLine)) {
            return eolCol + this.columnCorrections.get(eolLine);
        }
        return eolCol;
    }

    void setEglLineNumberForCurrentEolLineNumber(int eglLineNumber) {
        ++this.currentEolLine;
        this.lineNumberMapping.put(this.currentEolLine, eglLineNumber);
        this.maximumEglLineNumber = Math.max(this.maximumEglLineNumber, eglLineNumber);
    }

    void incrementColumnCorrectionNumber(int correction) {
        if (this.columnCorrections.containsKey(this.currentEolLine)) {
            this.columnCorrections.put(this.currentEolLine, correction + this.columnCorrections.get(this.currentEolLine));
        } else {
            this.columnCorrections.put(this.currentEolLine, correction);
        }
    }

    void reset() {
        this.lineNumberMapping.clear();
        this.columnCorrections.clear();
        this.currentEolLine = 0;
        this.maximumEglLineNumber = 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int eolLine = 1;
        while (eolLine <= this.currentEolLine) {
            builder.append(eolLine);
            builder.append(" -> ");
            builder.append(this.getEglLineNumberFor(eolLine));
            builder.append(" [");
            builder.append(this.getEglColumnNumberFor(eolLine, 0));
            builder.append("]");
            builder.append(FileUtil.NEWLINE);
            ++eolLine;
        }
        return builder.toString();
    }
}

