/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.plainxml;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epsilon.emc.plainxml.LoudListListener;

public class LoudList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    protected ArrayList<LoudListListener<E>> listeners = new ArrayList();
    protected boolean unique = false;

    public static void main(String[] args) {
        LoudList<Integer> list = new LoudList<Integer>();
        list.addListener(new LoudListListener<Integer>(){

            @Override
            public void objectRemoved(LoudList<Integer> list, Integer o, int index) {
                System.err.println("Removed " + o + "->" + index);
            }

            @Override
            public void objectRemoved(LoudList<Integer> list, Integer o) {
                System.err.println("Removed " + o);
            }

            @Override
            public void objectAdded(LoudList<Integer> list, Integer o, int index) {
            }

            @Override
            public void objectAdded(LoudList<Integer> list, Integer o) {
                System.err.println("Added " + o);
            }
        });
        list.add(1);
        list.add(1);
        list.remove(1);
        list.add(2);
        list.clear();
    }

    public void addListener(LoudListListener<E> listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(LoudListListener<E> listener) {
        return this.listeners.remove(listener);
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public boolean add(E e) {
        if (this.unique && this.contains(e)) {
            return false;
        }
        boolean result = super.add(e);
        for (LoudListListener<E> listener : this.listeners) {
            listener.objectAdded(this, e);
        }
        return result;
    }

    @Override
    public void add(int index, E element) {
        if (this.unique && this.contains(element)) {
            return;
        }
        super.add(index, element);
        for (LoudListListener<E> listener : this.listeners) {
            listener.objectAdded(this, element, index);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E o : c) {
            boolean bl = modified = modified || this.add(o);
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E o : c) {
            this.add(index, o);
        }
        return true;
    }

    @Override
    public void clear() {
        ArrayList temp = new ArrayList();
        temp.addAll(this);
        super.clear();
        for (Object o : temp) {
            for (LoudListListener listener : this.listeners) {
                listener.objectRemoved(this, o);
            }
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        for (LoudListListener<Object> loudListListener : this.listeners) {
            loudListListener.objectRemoved(this, o);
        }
        return result;
    }

    @Override
    public E remove(int index) {
        Object removed = super.remove(index);
        for (LoudListListener listener : this.listeners) {
            listener.objectRemoved(this, removed, index);
        }
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            boolean bl = modified = modified || this.remove(o);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        Object oldValue = this.get(index);
        if (element != oldValue) {
            this.remove(index);
            this.add(index, element);
        }
        return oldValue;
    }
}

