/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.AbstractToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.util.ReflectionUtil;

public class EolClasspathNativeTypeDelegate
extends AbstractToolNativeTypeDelegate {
    private ClassLoader fClassLoader;

    public EolClasspathNativeTypeDelegate() {
        this(EolClasspathNativeTypeDelegate.class.getClassLoader());
    }

    public EolClasspathNativeTypeDelegate(ClassLoader classLoader) {
        this.fClassLoader = classLoader;
    }

    @Override
    public boolean knowsAbout(String clazz) {
        try {
            this.fClassLoader.loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public Object createInstance(String clazz, List<Object> parameters) throws EolRuntimeException {
        block7: {
            try {
                Class<?> c = this.fClassLoader.loadClass(clazz);
                if (parameters.size() > 0) {
                    Constructor<?>[] constructorArray = c.getConstructors();
                    int n = constructorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constructor<?> con = constructorArray[n2];
                        if (con.getParameterTypes().length == parameters.size()) {
                            boolean parameterTypesMatch = true;
                            int i = 0;
                            while (i < parameters.size()) {
                                parameterTypesMatch = parameterTypesMatch && ReflectionUtil.isInstance(con.getParameterTypes()[i], parameters.get(i));
                                ++i;
                            }
                            if (parameterTypesMatch) {
                                return con.newInstance(parameters.toArray());
                            }
                        }
                        ++n2;
                    }
                    break block7;
                }
                return c.newInstance();
            }
            catch (Exception e) {
                throw new EolInternalException(e);
            }
        }
        throw new EolRuntimeException("Native type " + clazz + " does not define a suitable constructor for arguments " + parameters);
    }

    public Class<?>[] getTypes(Collection<Object> objects) {
        Class[] types = new Class[objects.size()];
        int i = 0;
        for (Object o : objects) {
            types[i] = o.getClass();
            ++i;
        }
        return types;
    }
}

