/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.profiling.Profiler;
import org.eclipse.epsilon.workflow.tasks.EpsilonTask;
import org.eclipse.epsilon.workflow.tasks.ShutdownProjectRepositoryListener;
import org.eclipse.epsilon.workflow.tasks.hosts.HostManager;
import org.eclipse.epsilon.workflow.tasks.nestedelements.ParameterNestedElement;

public class LoadModelTask
extends EpsilonTask {
    protected String name;
    protected String type;
    protected String impl;
    protected String config;
    protected ArrayList<ParameterNestedElement> parameterNestedElements = new ArrayList();

    @Override
    public void executeImpl() throws BuildException {
        IModel model;
        ShutdownProjectRepositoryListener.activate(this.getProject(), this.getProjectRepository());
        if (this.profile) {
            Profiler.INSTANCE.start("Load model : " + this.name);
        }
        if ((model = this.createModel(this.type)) == null) {
            if (this.impl != null) {
                try {
                    model = (IModel)Class.forName(this.impl).newInstance();
                }
                catch (Exception ex) {
                    throw new BuildException((Throwable)ex);
                }
            } else {
                throw new BuildException("Could not instantiate a model of type " + this.type + ". " + "This is either due to a typo or because you're running ANT outside Eclipse. " + "Try setting the impl property of the task to the fully-qualified name of the " + "class that implements the IModel interface.");
            }
        }
        try {
            try {
                model.load(this.getStringProperties(), null);
                model.setName(this.name);
                this.getProjectRepository().addModel(model);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            if (this.profile) {
                Profiler.INSTANCE.stop("Load model : " + this.name);
            }
        }
    }

    public String getImpl() {
        return this.impl;
    }

    public void setImpl(String impl) {
        this.impl = impl;
    }

    protected StringProperties getStringProperties() {
        StringProperties properties = new StringProperties();
        for (ParameterNestedElement parameterNestedElement : this.parameterNestedElements) {
            properties.put(parameterNestedElement.getName(), parameterNestedElement.getValue());
        }
        return properties;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ParameterNestedElement createParameter() {
        ParameterNestedElement parameterNestedElement = new ParameterNestedElement();
        this.parameterNestedElements.add(parameterNestedElement);
        return parameterNestedElement;
    }

    protected IModel createModel(String type) throws BuildException {
        return HostManager.getHost().createModel(type);
    }
}

