/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.singleobjective.geneticalgorithm;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GenerationalGeneticAlgorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.SteadyStateGeneticAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class GeneticAlgorithmBuilder<S extends Solution<?>> {
    private Problem<S> problem;
    private int maxEvaluations;
    private int populationSize;
    private CrossoverOperator<S> crossoverOperator;
    private MutationOperator<S> mutationOperator;
    private SelectionOperator<List<S>, S> selectionOperator;
    private SolutionListEvaluator<S> evaluator;
    private GeneticAlgorithmVariant variant;
    private SelectionOperator<List<S>, S> defaultSelectionOperator = new BinaryTournamentSelection();

    public GeneticAlgorithmBuilder(Problem<S> problem, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator) {
        this.problem = problem;
        this.maxEvaluations = 25000;
        this.populationSize = 100;
        this.mutationOperator = mutationOperator;
        this.crossoverOperator = crossoverOperator;
        this.selectionOperator = this.defaultSelectionOperator;
        this.evaluator = new SequentialSolutionListEvaluator();
        this.variant = GeneticAlgorithmVariant.GENERATIONAL;
    }

    public GeneticAlgorithmBuilder<S> setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    public GeneticAlgorithmBuilder<S> setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        return this;
    }

    public GeneticAlgorithmBuilder<S> setSelectionOperator(SelectionOperator<List<S>, S> selectionOperator) {
        this.selectionOperator = selectionOperator;
        return this;
    }

    public GeneticAlgorithmBuilder<S> setSolutionListEvaluator(SolutionListEvaluator<S> evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public GeneticAlgorithmBuilder<S> setVariant(GeneticAlgorithmVariant variant) {
        this.variant = variant;
        return this;
    }

    public Algorithm<S> build() {
        if (this.variant == GeneticAlgorithmVariant.GENERATIONAL) {
            return new GenerationalGeneticAlgorithm<S>(this.problem, this.maxEvaluations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator, this.evaluator);
        }
        if (this.variant == GeneticAlgorithmVariant.STEADY_STATE) {
            return new SteadyStateGeneticAlgorithm<S>(this.problem, this.maxEvaluations, this.populationSize, this.crossoverOperator, this.mutationOperator, this.selectionOperator);
        }
        throw new JMetalException("Unknown variant: " + (Object)((Object)this.variant));
    }

    public Problem<S> getProblem() {
        return this.problem;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public CrossoverOperator<S> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public MutationOperator<S> getMutationOperator() {
        return this.mutationOperator;
    }

    public SelectionOperator<List<S>, S> getSelectionOperator() {
        return this.selectionOperator;
    }

    public SolutionListEvaluator<S> getEvaluator() {
        return this.evaluator;
    }

    public GeneticAlgorithmVariant getVariant() {
        return this.variant;
    }

    public static enum GeneticAlgorithmVariant {
        GENERATIONAL,
        STEADY_STATE;

    }
}

