/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class Viennet3
extends AbstractDoubleProblem {
    public Viennet3() {
        this.setNumberOfVariables(2);
        this.setNumberOfObjectives(3);
        this.setNumberOfConstraints(0);
        this.setName("Viennet3");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-3.0);
            upperLimit.add(3.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] f = new double[this.getNumberOfObjectives()];
        double[] x = new double[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            x[i] = (Double)solution.getVariableValue(i);
        }
        f[0] = 0.5 * (x[0] * x[0] + x[1] * x[1]) + Math.sin(x[0] * x[0] + x[1] * x[1]);
        double value1 = 3.0 * x[0] - 2.0 * x[1] + 4.0;
        double value2 = x[0] - x[1] + 1.0;
        f[1] = value1 * value1 / 8.0 + value2 * value2 / 27.0 + 15.0;
        f[2] = 1.0 / (x[0] * x[0] + x[1] * x[1] + 1.0) - 1.1 * Math.exp(-(x[0] * x[0]) - x[1] * x[1]);
        for (int i = 0; i < this.getNumberOfObjectives(); ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

