/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.localsearch;

import java.util.Comparator;
import org.uma.jmetal.operator.LocalSearchOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.problem.ConstrainedProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.impl.OverallConstraintViolationComparator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class BasicLocalSearch<S extends Solution<?>>
implements LocalSearchOperator<S> {
    private Problem<S> problem;
    private int improvementRounds;
    private Comparator<S> constraintComparator;
    private Comparator<S> comparator;
    private MutationOperator<S> mutationOperator;
    private int evaluations;
    private int numberOfImprovements;
    private JMetalRandom randomGenerator;
    private int numberOfNonComparableSolutions;

    public BasicLocalSearch(int improvementRounds, MutationOperator<S> mutationOperator, Comparator<S> comparator, Problem<S> problem) {
        this.problem = problem;
        this.mutationOperator = mutationOperator;
        this.improvementRounds = improvementRounds;
        this.comparator = comparator;
        this.constraintComparator = new OverallConstraintViolationComparator();
        this.randomGenerator = JMetalRandom.getInstance();
        this.numberOfImprovements = 0;
    }

    @Override
    public S execute(S solution) {
        this.evaluations = 0;
        this.numberOfNonComparableSolutions = 0;
        int rounds = this.improvementRounds;
        for (int i = 0; i < rounds; ++i) {
            int best;
            Solution mutatedSolution = (Solution)this.mutationOperator.execute(solution.copy());
            if (this.problem.getNumberOfConstraints() > 0) {
                ((ConstrainedProblem)this.problem).evaluateConstraints(mutatedSolution);
                best = this.constraintComparator.compare(mutatedSolution, solution);
                if (best == 0) {
                    this.problem.evaluate(mutatedSolution);
                    ++this.evaluations;
                    best = this.comparator.compare(mutatedSolution, solution);
                } else if (best == -1) {
                    this.problem.evaluate(mutatedSolution);
                    ++this.evaluations;
                }
            } else {
                this.problem.evaluate(mutatedSolution);
                ++this.evaluations;
                best = this.comparator.compare(mutatedSolution, solution);
            }
            if (best == -1) {
                solution = mutatedSolution;
                ++this.numberOfImprovements;
                continue;
            }
            if (best == 1) continue;
            ++this.numberOfNonComparableSolutions;
            if (!(this.randomGenerator.nextDouble() < 0.5)) continue;
            solution = mutatedSolution;
        }
        return (S)solution.copy();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations;
    }

    @Override
    public int getNumberOfImprovements() {
        return this.numberOfImprovements;
    }

    @Override
    public int getNumberOfNonComparableSolutions() {
        return this.numberOfNonComparableSolutions;
    }
}

