/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.parallel;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class KMeansProcessor<V extends NumberVector>
implements Processor {
    Relation<V> relation;
    NumberVectorDistanceFunction<? super V> distance;
    WritableIntegerDataStore assignment;
    List<Vector> means;
    double[][] centroids;
    int[] sizes;
    double[] varsum;
    boolean changed = false;

    public KMeansProcessor(Relation<V> relation, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, WritableIntegerDataStore writableIntegerDataStore, double[] dArray) {
        this.distance = numberVectorDistanceFunction;
        this.relation = relation;
        this.assignment = writableIntegerDataStore;
        this.varsum = dArray;
    }

    public boolean changed() {
        return this.changed;
    }

    public void nextIteration(List<Vector> list) {
        this.means = list;
        this.changed = false;
        int n = list.size();
        int n2 = list.get(0).getDimensionality();
        this.centroids = new double[n][n2];
        this.sizes = new int[n];
        Arrays.fill(this.varsum, 0.0);
    }

    @Override
    public Instance<V> instantiate(Executor executor) {
        return new Instance<V>(this.relation, this.distance, this.assignment, this.means);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(Processor.Instance instance) {
        Instance instance2 = (Instance)instance;
        KMeansProcessor kMeansProcessor = this;
        synchronized (kMeansProcessor) {
            this.changed |= instance2.changed;
            for (int i = 0; i < this.centroids.length; ++i) {
                int n = instance2.sizes[i];
                if (n == 0) continue;
                int n2 = this.sizes[i];
                double d = n2 + n;
                double[] dArray = this.centroids[i];
                if (n2 > 0) {
                    VMath.timesEquals(dArray, (double)n2 / d);
                }
                VMath.plusTimesEquals(dArray, instance2.centroids[i], 1.0 / d);
                int n3 = i;
                this.sizes[n3] = this.sizes[n3] + n;
                VMath.plusEquals(this.varsum, instance2.varsum);
            }
        }
    }

    public List<Vector> getMeans() {
        ArrayList<Vector> arrayList = new ArrayList<Vector>(this.centroids.length);
        for (int i = 0; i < this.centroids.length; ++i) {
            if (this.sizes[i] == 0) {
                arrayList.add(this.means.get(i));
                continue;
            }
            arrayList.add(new Vector(this.centroids[i]));
        }
        return arrayList;
    }

    public static class Instance<V extends NumberVector>
    implements Processor.Instance {
        private Relation<V> relation;
        private NumberVectorDistanceFunction<? super V> distance;
        private WritableIntegerDataStore assignment;
        private Vector[] means;
        private double[][] centroids;
        private int[] sizes;
        private double[] varsum;
        private boolean changed = false;

        public Instance(Relation<V> relation, NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, WritableIntegerDataStore writableIntegerDataStore, List<? extends NumberVector> list) {
            int n;
            this.relation = relation;
            this.distance = numberVectorDistanceFunction;
            this.assignment = writableIntegerDataStore;
            int n2 = list.size();
            this.means = new Vector[n2];
            Iterator<? extends NumberVector> iterator = list.iterator();
            for (n = 0; n < n2; ++n) {
                this.means[n] = iterator.next().getColumnVector();
            }
            n = this.means[0].getDimensionality();
            this.centroids = new double[n2][n];
            this.sizes = new int[n2];
            this.varsum = new double[n2];
        }

        @Override
        public void map(DBIDRef dBIDRef) {
            int n;
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDRef);
            double d = Double.POSITIVE_INFINITY;
            int n2 = 0;
            for (n = 0; n < this.means.length; ++n) {
                double d2 = this.distance.distance(numberVector, this.means[n]);
                if (!(d2 < d)) continue;
                n2 = n;
                d = d2;
            }
            int n3 = n2;
            this.varsum[n3] = this.varsum[n3] + d;
            n = this.assignment.putInt(dBIDRef, n2);
            this.changed |= n != n2;
            double[] dArray = this.centroids[n2];
            for (int i = 0; i < numberVector.getDimensionality(); ++i) {
                int n4 = i;
                dArray[n4] = dArray[n4] + numberVector.doubleValue(i);
            }
            int n5 = n2;
            this.sizes[n5] = this.sizes[n5] + 1;
        }
    }
}

