/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.AbstractSpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Reference(authors="D. Hilbert", title="\u00dcber die stetige Abbildung einer Linie auf ein Fl\u00e4chenst\u00fcck", booktitle="Mathematische Annalen, 38(3)")
public class HilbertSpatialSorter
extends AbstractSpatialSorter {
    @Override
    public <T extends SpatialComparable> void sort(List<T> list, int n, int n2, double[] dArray, int[] nArray) {
        int n3;
        int n4 = nArray != null ? nArray.length : dArray.length >> 1;
        ArrayList<HilbertRef<SpatialComparable>> arrayList = new ArrayList<HilbertRef<SpatialComparable>>(n2 - n);
        int[] nArray2 = new int[n4];
        for (n3 = n; n3 < n2; ++n3) {
            SpatialComparable spatialComparable = (SpatialComparable)list.get(n3);
            for (int i = 0; i < n4; ++i) {
                int n5 = nArray != null ? nArray[i] : i;
                int n6 = n5 << 1;
                double d = (spatialComparable.getMin(n5) + spatialComparable.getMax(n5)) * 0.5;
                d = 2.147483647E9 * ((d - dArray[n6]) / (dArray[n6 + 1] - dArray[n6]));
                nArray2[i] = (int)d;
            }
            arrayList.add(new HilbertRef<SpatialComparable>(spatialComparable, HilbertSpatialSorter.coordinatesToHilbert(nArray2, 31, 1)));
        }
        Collections.sort(arrayList);
        for (n3 = n; n3 < n2; ++n3) {
            list.set(n3, ((HilbertRef)arrayList.get((int)(n3 - n))).vec);
        }
    }

    public static long[] coordinatesToHilbert(long[] lArray, int n, int n2) {
        int n3 = lArray.length;
        int n4 = n3 * n;
        long[] lArray2 = BitsUtil.zero(n4);
        int n5 = 0;
        long[] lArray3 = BitsUtil.zero(n3);
        for (int i = 0; i < n; ++i) {
            long[] lArray4 = HilbertSpatialSorter.interleaveBits(lArray, i + n2);
            long[] lArray5 = BitsUtil.copy(lArray4);
            BitsUtil.xorI(lArray5, lArray3);
            BitsUtil.cycleRightI(lArray5, n5, n3);
            int n6 = (n5 + BitsUtil.numberOfTrailingZerosSigned(lArray5) + 2) % n3;
            BitsUtil.invgrayI(lArray5);
            BitsUtil.orI(lArray2, lArray5, n4 - (i + 1) * n3);
            lArray3 = lArray4;
            BitsUtil.flipI(lArray3, n5);
            if (!BitsUtil.get(lArray5, 0)) {
                BitsUtil.flipI(lArray3, (n6 - 1 + n3) % n3);
            }
            n5 = n6;
        }
        return lArray2;
    }

    public static long[] coordinatesToHilbert(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int n4 = n3 * n;
        long[] lArray = BitsUtil.zero(n4);
        int n5 = 0;
        long[] lArray2 = BitsUtil.zero(n3);
        for (int i = 0; i < n; ++i) {
            long[] lArray3 = HilbertSpatialSorter.interleaveBits(nArray, i + n2);
            long[] lArray4 = BitsUtil.copy(lArray3);
            BitsUtil.xorI(lArray4, lArray2);
            BitsUtil.cycleRightI(lArray4, n5, n3);
            int n6 = (n5 + BitsUtil.numberOfTrailingZerosSigned(lArray4) + 2) % n3;
            BitsUtil.invgrayI(lArray4);
            BitsUtil.orI(lArray, lArray4, n4 - (i + 1) * n3);
            lArray2 = lArray3;
            BitsUtil.flipI(lArray2, n5);
            if (!BitsUtil.get(lArray4, 0)) {
                BitsUtil.flipI(lArray2, (n6 - 1 + n3) % n3);
            }
            n5 = n6;
        }
        return lArray;
    }

    public static long[] coordinatesToHilbert(short[] sArray, int n, int n2) {
        int n3 = sArray.length;
        int n4 = n3 * n;
        long[] lArray = BitsUtil.zero(n4);
        int n5 = 0;
        long[] lArray2 = BitsUtil.zero(n3);
        for (int i = 0; i < n; ++i) {
            long[] lArray3 = HilbertSpatialSorter.interleaveBits(sArray, i + n2);
            long[] lArray4 = BitsUtil.copy(lArray3);
            BitsUtil.xorI(lArray4, lArray2);
            BitsUtil.cycleRightI(lArray4, n5, n3);
            int n6 = (n5 + BitsUtil.numberOfTrailingZerosSigned(lArray4) + 2) % n3;
            BitsUtil.invgrayI(lArray4);
            BitsUtil.orI(lArray, lArray4, n4 - (i + 1) * n3);
            lArray2 = lArray3;
            BitsUtil.flipI(lArray2, n5);
            if (!BitsUtil.get(lArray4, 0)) {
                BitsUtil.flipI(lArray2, (n6 - 1 + n3) % n3);
            }
            n5 = n6;
        }
        return lArray;
    }

    public static long[] coordinatesToHilbert(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        int n4 = n3 * n;
        long[] lArray = BitsUtil.zero(n4);
        int n5 = 0;
        long[] lArray2 = BitsUtil.zero(n3);
        for (int i = 0; i < n; ++i) {
            long[] lArray3 = HilbertSpatialSorter.interleaveBits(byArray, i + n2);
            long[] lArray4 = BitsUtil.copy(lArray3);
            BitsUtil.xorI(lArray4, lArray2);
            BitsUtil.cycleRightI(lArray4, n5, n3);
            int n6 = (n5 + BitsUtil.numberOfTrailingZerosSigned(lArray4) + 2) % n3;
            BitsUtil.invgrayI(lArray4);
            BitsUtil.orI(lArray, lArray4, n4 - (i + 1) * n3);
            lArray2 = lArray3;
            BitsUtil.flipI(lArray2, n5);
            if (!BitsUtil.get(lArray4, 0)) {
                BitsUtil.flipI(lArray2, (n6 - 1 + n3) % n3);
            }
            n5 = n6;
        }
        return lArray;
    }

    public static long[] interleaveBits(long[] lArray, int n) {
        int n2 = lArray.length;
        long[] lArray2 = BitsUtil.zero(n2);
        long l = 1L << 63 - n;
        for (int i = 0; i < n2; ++i) {
            if ((lArray[i] & l) == 0L) continue;
            BitsUtil.setI(lArray2, i);
        }
        return lArray2;
    }

    public static long[] interleaveBits(int[] nArray, int n) {
        int n2 = nArray.length;
        long[] lArray = BitsUtil.zero(n2);
        long l = 1L << 31 - n;
        for (int i = 0; i < n2; ++i) {
            if (((long)nArray[i] & l) == 0L) continue;
            BitsUtil.setI(lArray, i);
        }
        return lArray;
    }

    public static long[] interleaveBits(short[] sArray, int n) {
        int n2 = sArray.length;
        long[] lArray = BitsUtil.zero(n2);
        long l = 1L << 15 - n;
        for (int i = 0; i < n2; ++i) {
            if (((long)sArray[i] & l) == 0L) continue;
            BitsUtil.setI(lArray, i);
        }
        return lArray;
    }

    public static long[] interleaveBits(byte[] byArray, int n) {
        int n2 = byArray.length;
        long[] lArray = BitsUtil.zero(n2);
        long l = 1L << 7 - n;
        for (int i = 0; i < n2; ++i) {
            if (((long)byArray[i] & l) == 0L) continue;
            BitsUtil.setI(lArray, i);
        }
        return lArray;
    }

    private static class HilbertRef<T extends SpatialComparable>
    implements Comparable<HilbertRef<T>> {
        protected T vec;
        protected long[] bits;

        protected HilbertRef(T t, long[] lArray) {
            this.vec = t;
            this.bits = lArray;
        }

        @Override
        public int compareTo(HilbertRef<T> hilbertRef) {
            return BitsUtil.compare(this.bits, hilbertRef.bits);
        }
    }
}

