/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class KappaDistribution
extends AbstractDistribution {
    double location;
    double scale;
    double shape1;
    double shape2;

    public KappaDistribution(double d, double d2, double d3, double d4) {
        this(d, d2, d3, d4, (Random)null);
    }

    public KappaDistribution(double d, double d2, double d3, double d4, Random random) {
        super(random);
        this.location = d;
        this.scale = d2;
        this.shape1 = d3;
        this.shape2 = d4;
        if (d4 >= 0.0) {
            if (d3 < -1.0) {
                throw new ArithmeticException("Invalid shape1 parameter - must be greater than -1 if shape2 >= 0.!");
            }
        } else if (d3 < 1.0 || d3 > 1.0 / d4) {
            throw new ArithmeticException("Invalid shape1 parameter - must be -1 to +1/shape2 if shape2 < 0.!");
        }
    }

    public KappaDistribution(double d, double d2, double d3, double d4, RandomFactory randomFactory) {
        super(randomFactory);
        this.location = d;
        this.scale = d2;
        this.shape1 = d3;
        this.shape2 = d4;
        if (d4 >= 0.0) {
            if (d3 < -1.0) {
                throw new ArithmeticException("Invalid shape1 parameter - must be greater than -1 if shape2 >= 0.!");
            }
        } else if (d3 < 1.0 || d3 > 1.0 / d4) {
            throw new ArithmeticException("Invalid shape1 parameter - must be -1 to +1/shape2 if shape2 < 0.!");
        }
    }

    public static double pdf(double d, double d2, double d3, double d4, double d5) {
        double d6 = KappaDistribution.cdf(d, d2, d3, d4, d5);
        d = (d - d2) / d3;
        if (d4 != 0.0) {
            if ((d = 1.0 - d4 * d) < 1.0E-15) {
                return 0.0;
            }
            d = (1.0 - 1.0 / d4) * Math.log(d);
        }
        d = Math.exp(-d);
        return d / d3 * Math.pow(d6, 1.0 - d5);
    }

    @Override
    public double pdf(double d) {
        return KappaDistribution.pdf(d, this.location, this.scale, this.shape1, this.shape2);
    }

    public static double cdf(double d, double d2, double d3, double d4, double d5) {
        double d6;
        d = (d - d2) / d3;
        if (d4 != 0.0) {
            d6 = 1.0 - d4 * d;
            if (d6 < 1.0E-15) {
                return d4 < 0.0 ? 0.0 : 1.0;
            }
            d = Math.exp(Math.log(d6) / d4);
        } else {
            d = Math.exp(-d);
        }
        if (d5 != 0.0) {
            d6 = 1.0 - d5 * d;
            if (d6 < 1.0E-15) {
                return 0.0;
            }
            d = Math.exp(Math.log(d6) / d5);
        } else {
            d = Math.exp(-d);
        }
        return d;
    }

    @Override
    public double cdf(double d) {
        return KappaDistribution.cdf(d, this.location, this.scale, this.shape1, this.shape2);
    }

    public static double quantile(double d, double d2, double d3, double d4, double d5) {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            if (d5 <= 0.0) {
                if (d4 < 0.0) {
                    return d2 + d3 / d4;
                }
                return Double.NEGATIVE_INFINITY;
            }
            if (d4 != 0.0) {
                return d2 + d3 / d4 * (1.0 - Math.pow(d5, -d4));
            }
            return d2 + d3 * Math.log(d5);
        }
        if (d == 1.0) {
            if (d4 <= 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return d2 + d3 / d4;
        }
        d = -Math.log(d);
        if (d5 != 0.0) {
            d = (1.0 - Math.exp(-d5 * d)) / d5;
        }
        d = -Math.log(d);
        if (d4 != 0.0) {
            d = (1.0 - Math.exp(-d4 * d)) / d4;
        }
        return d2 + d3 * d;
    }

    @Override
    public double quantile(double d) {
        return KappaDistribution.quantile(d, this.location, this.scale, this.shape1, this.shape2);
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextDouble();
        return KappaDistribution.quantile(d, this.location, this.scale, this.shape1, this.shape2);
    }

    @Override
    public String toString() {
        return "KappaDistribution(location=" + this.location + ", scale=" + this.scale + ", shape1=" + this.shape1 + ", shape2=" + this.shape2 + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SHAPE1_ID = new OptionID("distribution.kappa.shape1", "First shape parameter of kappa distribution.");
        public static final OptionID SHAPE2_ID = new OptionID("distribution.kappa.shape2", "Second shape parameter of kappa distribution.");
        double location;
        double scale;
        double shape1;
        double shape2;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            DoubleParameter doubleParameter3;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter4 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter4)) {
                this.location = doubleParameter4.doubleValue();
            }
            if (parameterization.grab(doubleParameter3 = new DoubleParameter(SCALE_ID))) {
                this.scale = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(SHAPE1_ID))) {
                this.shape1 = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHAPE2_ID))) {
                this.shape2 = doubleParameter.doubleValue();
            }
        }

        @Override
        protected KappaDistribution makeInstance() {
            return new KappaDistribution(this.location, this.scale, this.shape1, this.shape2, this.rnd);
        }
    }
}

