/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.abyss;

import org.uma.jmetal.algorithm.multiobjective.abyss.ABYSS;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.LocalSearchOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.localsearch.ArchiveMutationLocalSearch;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmBuilder;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;

public class ABYSSBuilder
implements AlgorithmBuilder<ABYSS> {
    private DoubleProblem problem;
    private CrossoverOperator<DoubleSolution> crossoverOperator;
    protected LocalSearchOperator<DoubleSolution> improvementOperator;
    private MutationOperator<DoubleSolution> mutationOperator;
    private int numberOfSubranges = 4;
    private int populationSize = 20;
    private int refSet1Size = 10;
    private int refSet2Size = 10;
    private int archiveSize = 100;
    private int maxEvaluations = 25000;
    private CrowdingDistanceArchive<DoubleSolution> archive;

    public ABYSSBuilder(DoubleProblem problem, Archive<DoubleSolution> archive) {
        this.problem = problem;
        double crossoverProbability = 0.9;
        double distributionIndex = 20.0;
        this.crossoverOperator = new SBXCrossover(crossoverProbability, distributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        this.mutationOperator = new PolynomialMutation(mutationProbability, distributionIndex);
        int improvementRounds = 1;
        this.archive = (CrowdingDistanceArchive)archive;
        this.improvementOperator = new ArchiveMutationLocalSearch<DoubleSolution>(improvementRounds, this.mutationOperator, this.archive, problem);
    }

    public CrossoverOperator<DoubleSolution> getCrossoverOperator() {
        return this.crossoverOperator;
    }

    public ABYSSBuilder setCrossoverOperator(CrossoverOperator<DoubleSolution> crossoverOperator) {
        this.crossoverOperator = crossoverOperator;
        return this;
    }

    public LocalSearchOperator<DoubleSolution> getImprovementOperator() {
        return this.improvementOperator;
    }

    public ABYSSBuilder setImprovementOperator(ArchiveMutationLocalSearch<DoubleSolution> improvementOperator) {
        this.improvementOperator = improvementOperator;
        return this;
    }

    public MutationOperator<DoubleSolution> getMutationOperator() {
        return this.mutationOperator;
    }

    public ABYSSBuilder setMutationOperator(MutationOperator<DoubleSolution> mutationOperator) {
        this.mutationOperator = mutationOperator;
        return this;
    }

    public int getNumberOfSubranges() {
        return this.numberOfSubranges;
    }

    public ABYSSBuilder setNumberOfSubranges(int numberOfSubranges) {
        this.numberOfSubranges = numberOfSubranges;
        return this;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public ABYSSBuilder setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
        return this;
    }

    public int getRefSet1Size() {
        return this.refSet1Size;
    }

    public ABYSSBuilder setRefSet1Size(int refSet1Size) {
        this.refSet1Size = refSet1Size;
        return this;
    }

    public int getRefSet2Size() {
        return this.refSet2Size;
    }

    public ABYSSBuilder setRefSet2Size(int refSet2Size) {
        this.refSet2Size = refSet2Size;
        return this;
    }

    public int getArchiveSize() {
        return this.archiveSize;
    }

    public ABYSSBuilder setArchiveSize(int archiveSize) {
        this.archiveSize = archiveSize;
        return this;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public ABYSSBuilder setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
        return this;
    }

    @Override
    public ABYSS build() {
        return new ABYSS(this.problem, this.maxEvaluations, this.populationSize, this.refSet1Size, this.refSet2Size, this.archiveSize, this.archive, this.improvementOperator, this.crossoverOperator, this.numberOfSubranges);
    }
}

