/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.correlation;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class UncenteredCorrelationDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final UncenteredCorrelationDistanceFunction STATIC = new UncenteredCorrelationDistanceFunction();

    @Deprecated
    public UncenteredCorrelationDistanceFunction() {
    }

    public static double uncenteredCorrelation(NumberVector numberVector, NumberVector numberVector2) {
        int n;
        int n2 = numberVector.getDimensionality();
        if (n2 != (n = numberVector2.getDimensionality())) {
            throw new IllegalArgumentException("Invalid arguments: number vectors differ in dimensionality.");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d4 = numberVector.doubleValue(i);
            double d5 = numberVector2.doubleValue(i);
            d += d4 * d4;
            d2 += d5 * d5;
            d3 += d4 * d5;
        }
        if (!(d > 0.0) || !(d2 > 0.0)) {
            return d == d2 ? 1.0 : 0.0;
        }
        return d3 / Math.sqrt(d * d2);
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        return 1.0 - UncenteredCorrelationDistanceFunction.uncenteredCorrelation(numberVector, numberVector2);
    }

    public String toString() {
        return "UncenteredCorrelationDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.getClass().equals(object.getClass());
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected UncenteredCorrelationDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

