/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.math.linearalgebra.EigenPair;
import de.lmu.ifi.dbs.elki.math.linearalgebra.SortedEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.FilteredEigenPairs;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.WeakEigenPairFilter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.ArrayList;

@Title(value="Significant EigenPair Filter")
@Description(value="Sorts the eigenpairs in decending order of their eigenvalues and looks for the maxmimum contrast of current Eigenvalue / average of remaining Eigenvalues.")
public class SignificantEigenPairFilter
implements EigenPairFilter {
    public static final double DEFAULT_WALPHA = 0.0;
    private double walpha;

    public SignificantEigenPairFilter(double d) {
        this.walpha = d;
    }

    @Override
    public FilteredEigenPairs filter(SortedEigenPairs sortedEigenPairs) {
        EigenPair eigenPair;
        int n;
        ArrayList<EigenPair> arrayList = new ArrayList<EigenPair>();
        ArrayList<EigenPair> arrayList2 = new ArrayList<EigenPair>();
        int n2 = sortedEigenPairs.size() - 1;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < sortedEigenPairs.size(); ++i) {
            EigenPair eigenPair2 = sortedEigenPairs.getEigenPair(i);
            d2 += eigenPair2.getEigenvalue();
        }
        double d3 = d2 / (double)sortedEigenPairs.size() * this.walpha;
        double d4 = sortedEigenPairs.getEigenPair(sortedEigenPairs.size() - 1).getEigenvalue();
        for (n = sortedEigenPairs.size() - 2; n >= 0; --n) {
            double d5;
            eigenPair = sortedEigenPairs.getEigenPair(n);
            d4 += eigenPair.getEigenvalue();
            if (eigenPair.getEigenvalue() < d3 || !((d5 = eigenPair.getEigenvalue() / (d4 / (double)(sortedEigenPairs.size() - n))) > d)) continue;
            d = d5;
            n2 = n;
        }
        for (n = 0; n <= n2; ++n) {
            eigenPair = sortedEigenPairs.getEigenPair(n);
            arrayList.add(eigenPair);
        }
        for (n = n2 + 1; n < sortedEigenPairs.size(); ++n) {
            eigenPair = sortedEigenPairs.getEigenPair(n);
            arrayList2.add(eigenPair);
        }
        return new FilteredEigenPairs(arrayList2, arrayList);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private double walpha;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = new DoubleParameter(WeakEigenPairFilter.Parameterizer.EIGENPAIR_FILTER_WALPHA, 0.0);
            doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.walpha = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected SignificantEigenPairFilter makeInstance() {
            return new SignificantEigenPairFilter(this.walpha);
        }
    }
}

