/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import java.util.Comparator;
import java.util.Random;

public final class Util {
    private static final long HASHPRIME = 2654435761L;
    public static final boolean IS_JAVA7 = System.getProperty("java.version").startsWith("1.7.");
    public static final boolean IS_ORACLE_JAVA = System.getProperty("java.vm.vendor").startsWith("Oracle");
    private static final Comparator<?> FORWARD = new ForwardComparator();

    private Util() {
    }

    public static long[] randomBitSet(int n, int n2, Random random) {
        assert (n >= 0) : "Cannot set a negative number of bits!";
        assert (n < n2) : "Cannot set " + n + " of " + n2 + " bits!";
        if (n < n2 >>> 1) {
            long[] lArray = BitsUtil.zero(n2);
            while (BitsUtil.cardinality(lArray) < n) {
                BitsUtil.setI(lArray, random.nextInt(n2));
            }
            return lArray;
        }
        long[] lArray = BitsUtil.ones(n2);
        while (BitsUtil.cardinality(lArray) > n) {
            BitsUtil.clearI(lArray, random.nextInt(n2));
        }
        return lArray;
    }

    @Deprecated
    public static int mixHashCodes(int n) {
        return n;
    }

    public static int mixHashCodes(int n, int n2) {
        return (int)((long)n * 2654435761L + (long)n2);
    }

    public static int mixHashCodes(int n, int n2, int n3) {
        long l = (long)n * 2654435761L + (long)n2;
        return (int)(l * 2654435761L + (long)n3);
    }

    public static int mixHashCodes(int ... nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        long l = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            l = l * 2654435761L + (long)nArray[i];
        }
        return (int)l;
    }

    public static <T> Comparator<T> forwardOrder() {
        return FORWARD;
    }

    private static final class ForwardComparator
    implements Comparator<Comparable<Object>> {
        private ForwardComparator() {
        }

        @Override
        public int compare(Comparable<Object> comparable, Comparable<Object> comparable2) {
            return comparable.compareTo(comparable2);
        }
    }
}

