/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.Heap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.TopBoundedHeap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class TiedTopBoundedHeap<E>
extends TopBoundedHeap<E> {
    private List<E> ties = new ArrayList();

    public TiedTopBoundedHeap(int n, Comparator<? super E> comparator) {
        super(n, comparator);
    }

    public TiedTopBoundedHeap(int n) {
        this(n, null);
    }

    @Override
    public int size() {
        return super.size() + this.ties.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.ties.clear();
    }

    @Override
    public E peek() {
        if (this.ties.isEmpty()) {
            return super.peek();
        }
        return this.ties.get(this.ties.size() - 1);
    }

    @Override
    public E poll() {
        if (this.ties.isEmpty()) {
            return super.poll();
        }
        return this.ties.remove(this.ties.size() - 1);
    }

    @Override
    public E replaceTopElement(E e) {
        if (this.ties.isEmpty()) {
            return super.replaceTopElement(e);
        }
        E e2 = this.poll();
        this.add(e);
        return e2;
    }

    @Override
    protected void handleOverflow(E e) {
        boolean bl = false;
        if (this.comparator == null) {
            Comparable comparable = (Comparable)e;
            if (comparable.compareTo(this.queue[0]) == 0) {
                bl = true;
            }
        } else if (this.comparator.compare(e, this.queue[0]) == 0) {
            bl = true;
        }
        if (bl) {
            this.ties.add(e);
        } else {
            this.ties.clear();
        }
    }

    @Override
    public UnorderedIter unorderedIter() {
        return new UnorderedIter();
    }

    public class UnorderedIter
    extends Heap.UnorderedIter {
        protected UnorderedIter() {
            super(TiedTopBoundedHeap.this);
        }

        @Override
        public boolean valid() {
            return this.pos < TiedTopBoundedHeap.this.size();
        }

        @Override
        public E get() {
            int n = TiedTopBoundedHeap.super.size();
            if (this.pos < n) {
                return super.get();
            }
            return TiedTopBoundedHeap.this.ties.get(this.pos - n);
        }
    }
}

