/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationParametersException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;
import org.eclipse.epsilon.eol.types.EolType;
import org.eclipse.epsilon.eol.types.IEolCollectionTypeResolver;

public class EolCollectionType
extends EolType {
    protected static Set<IEolCollectionTypeResolver> collectionTypeResolvers = null;
    private String name;
    public static EolCollectionType Collection = new EolCollectionType("Collection");
    public static EolCollectionType Bag = new EolCollectionType("Bag");
    public static EolCollectionType Sequence = new EolCollectionType("Sequence");
    public static EolCollectionType Set = new EolCollectionType("Set");
    public static EolCollectionType OrderedSet = new EolCollectionType("OrderedSet");

    public static Set<IEolCollectionTypeResolver> getCollectionTypeResolvers() {
        if (collectionTypeResolvers == null) {
            collectionTypeResolvers = new HashSet<IEolCollectionTypeResolver>();
        }
        return collectionTypeResolvers;
    }

    private EolCollectionType(String name) {
        this.name = name;
    }

    public EolCollectionType getTypeOf(Collection<?> c) {
        if (c instanceof EolSequence) {
            return Sequence;
        }
        if (c instanceof EolOrderedSet) {
            return OrderedSet;
        }
        if (c instanceof EolSet) {
            return Set;
        }
        if (c instanceof EolBag) {
            return Bag;
        }
        for (IEolCollectionTypeResolver collectionTypeResolver : EolCollectionType.getCollectionTypeResolvers()) {
            if (!collectionTypeResolver.canResolveType(c)) continue;
            return collectionTypeResolver.resolveType(c);
        }
        if (c instanceof List) {
            return c instanceof Set ? OrderedSet : Sequence;
        }
        if (c instanceof Set) {
            return Set;
        }
        return Bag;
    }

    @Override
    public boolean isType(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        if (this == Collection) {
            return false;
        }
        return this.getTypeOf(c) == this;
    }

    @Override
    public boolean isKind(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        EolCollectionType collectionType = this.getTypeOf((Collection)o);
        if (this == Collection) {
            return true;
        }
        if (this == Bag) {
            return collectionType == Bag || collectionType == Sequence;
        }
        if (this == Sequence) {
            return collectionType == Sequence;
        }
        if (this == OrderedSet) {
            return collectionType == OrderedSet;
        }
        if (this == Set) {
            return collectionType == Set || collectionType == OrderedSet;
        }
        return false;
    }

    @Override
    public Object createInstance() {
        block6: {
            try {
                if (this != Collection) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this == Bag) {
            return new EolBag();
        }
        if (this == Sequence) {
            return new EolSequence();
        }
        if (this == OrderedSet) {
            return new EolOrderedSet();
        }
        return new EolSet();
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        throw new EolIllegalOperationParametersException("createInstance");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static String getTypeName(Collection<?> c) {
        if (Bag.isType(c)) {
            return Bag.getName();
        }
        if (Sequence.isType(c)) {
            return Sequence.getName();
        }
        if (OrderedSet.isType(c)) {
            return OrderedSet.getName();
        }
        if (Set.isType(c)) {
            return Set.getName();
        }
        return c.getClass().getSimpleName();
    }

    public static <T> Collection<T> createSameType(Collection<T> c) {
        if (Bag.isType(c)) {
            return new EolBag();
        }
        if (Sequence.isType(c)) {
            return new EolSequence();
        }
        if (OrderedSet.isType(c)) {
            return new EolOrderedSet();
        }
        if (Set.isType(c)) {
            return new EolSet();
        }
        return null;
    }

    public static <T> Collection<T> clone(Collection<T> c) {
        Collection<T> clone = EolCollectionType.createSameType(c);
        clone.addAll(c);
        return clone;
    }

    public static <T> Collection<T> join(Collection<T> c1, Collection<T> c2) {
        Collection<T> joined = EolCollectionType.createSameType(c1);
        joined.addAll(c1);
        joined.addAll(c2);
        return joined;
    }

    public static boolean isUnique(Collection<?> c) {
        return Set.isType(c) || OrderedSet.isType(c);
    }

    public static boolean isOrdered(Collection<?> c) {
        return Sequence.isType(c) || OrderedSet.isType(c);
    }
}

