/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.util;

import java.util.List;
import org.eclipse.epsilon.emc.emf.tools.EmfTool;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;
import org.eclipse.epsilon.etl.EtlModule;
import org.eclipse.epsilon.etl.IEtlModule;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.IEvlFixer;
import org.eclipse.epsilon.evl.IEvlModule;

public abstract class EpsilonUtil {
    private EpsilonUtil() {
    }

    public static IEtlModule initialiseEtlModule(IModel source, IModel target, IModel ... extraModels) throws EolModelLoadingException {
        EtlModule transformer = new EtlModule();
        source.setStoredOnDisposal(false);
        target.setStoredOnDisposal(false);
        target.setReadOnLoad(false);
        transformer.getContext().getModelRepository().addModel(source);
        transformer.getContext().getModelRepository().addModel(target);
        EpsilonUtil.addExtraModels(transformer.getContext(), extraModels);
        EpsilonUtil.addNativeTypeDelegate(transformer.getContext());
        return transformer;
    }

    public static IEvlModule initialseEvlModule(IEvlFixer fixer, IModel model, IModel ... extraModels) throws EolModelLoadingException {
        EvlModule validator = new EvlModule();
        validator.setUnsatisfiedConstraintFixer(fixer);
        model.setReadOnLoad(true);
        model.setStoredOnDisposal(true);
        validator.getContext().getModelRepository().addModel(model);
        EpsilonUtil.addExtraModels(validator.getContext(), extraModels);
        EpsilonUtil.addNativeTypeDelegate(validator.getContext());
        return validator;
    }

    private static void addExtraModels(IEolContext context, IModel ... models) throws EolModelLoadingException {
        IModel[] iModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IModel model = iModelArray[n2];
            model.setStoredOnDisposal(false);
            context.getModelRepository().addModel(model);
            model.load();
            ++n2;
        }
    }

    private static void addNativeTypeDelegate(IEolContext context) {
        context.getNativeTypeDelegates().add(new IToolNativeTypeDelegate(){

            public Object createInstance(String clazz, IEolContext context) throws EolRuntimeException {
                return new EmfTool();
            }

            @Override
            public boolean knowsAbout(String clazz) {
                return "org.eclipse.epsilon.emc.emf.tools.EmfTool".equals(clazz);
            }

            @Override
            public Object createInstance(String clazz, List<Object> parameters, IEolContext context) throws EolRuntimeException {
                return this.createInstance(clazz, context);
            }
        });
    }
}

