/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Random;
import org.jgap.RandomGenerator;

public class GaussianRandomGenerator
implements RandomGenerator {
    private static final String CVS_REVISION = "$Revision: 1.21 $";
    private static final double DELTA = 1.0E-7;
    private Random m_rn;
    private double m_standardDeviation;

    public GaussianRandomGenerator() {
        this(1.0);
    }

    public GaussianRandomGenerator(double a_standardDeviation) {
        this.init();
        this.setGaussianStdDeviation(a_standardDeviation);
    }

    private void init() {
        this.m_rn = new Random();
    }

    public void setGaussianStdDeviation(double a_standardDeviation) {
        if (a_standardDeviation <= 1.0E-7) {
            throw new IllegalArgumentException("Standard deviation must be greater 0!");
        }
        this.m_standardDeviation = a_standardDeviation;
    }

    public double getGaussianStdDeviation() {
        return this.m_standardDeviation;
    }

    public int nextInt() {
        return Math.abs(Math.min(0x7FFFFFFE, (int)Math.round(this.nextGaussian() * 2.147483647E9)));
    }

    public int nextInt(int a_ceiling) {
        return Math.min(a_ceiling - 1, (int)Math.round(this.nextGaussian() * (double)a_ceiling / 11.6));
    }

    public long nextLong() {
        long result = Math.min(Long.MAX_VALUE, (long)(this.nextGaussian() * 9.223372036854776E18 / 11.6));
        return result;
    }

    public double nextDouble() {
        return this.nextGaussian();
    }

    public float nextFloat() {
        return (float)this.nextGaussian();
    }

    public boolean nextBoolean() {
        return this.nextGaussian() >= 0.5;
    }

    private double nextGaussian() {
        double r = (this.m_rn.nextGaussian() + 5.8) / 11.6;
        return r;
    }

    private void readObject(ObjectInputStream a_inputStream) throws IOException, ClassNotFoundException {
        a_inputStream.defaultReadObject();
        this.m_rn.setSeed(System.currentTimeMillis());
    }
}

