/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.Loader;
import weka.core.converters.URLSourcedLoader;
import weka.gui.ConverterFileChooser;
import weka.gui.InstancesSummaryPanel;

public class SetInstancesPanel
extends JPanel {
    private static final long serialVersionUID = -384804041420453735L;
    public static final String NO_CLASS = "No class";
    protected JButton m_OpenFileBut = new JButton("Open file...");
    protected JButton m_OpenURLBut = new JButton("Open URL...");
    protected JButton m_CloseBut = new JButton("Close");
    protected InstancesSummaryPanel m_Summary = new InstancesSummaryPanel();
    protected JLabel m_ClassLabel = new JLabel("Class");
    protected JComboBox m_ClassComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"No class"}));
    protected ConverterFileChooser m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
    protected String m_LastURL = "http://";
    protected Thread m_IOThread;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Instances m_Instances;
    protected Loader m_Loader;
    protected JFrame m_ParentFrame = null;
    protected JPanel m_CloseButPanel = null;
    protected boolean m_readIncrementally = true;
    protected boolean m_showZeroInstancesAsUnknown = false;
    protected boolean m_showClassComboBox;

    public SetInstancesPanel() {
        this(false, false, null);
    }

    public SetInstancesPanel(boolean showZeroInstancesAsUnknown, boolean showClassComboBox, ConverterFileChooser chooser) {
        JPanel panelButtonsAndClass;
        this.m_showZeroInstancesAsUnknown = showZeroInstancesAsUnknown;
        this.m_showClassComboBox = showClassComboBox;
        if (chooser != null) {
            this.m_FileChooser = chooser;
        }
        this.m_OpenFileBut.setToolTipText("Open a set of instances from a file");
        this.m_OpenURLBut.setToolTipText("Open a set of instances from a URL");
        this.m_CloseBut.setToolTipText("Closes the dialog");
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_OpenURLBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetInstancesPanel.this.setInstancesFromURLQ();
            }
        });
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetInstancesPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_CloseBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetInstancesPanel.this.closeFrame();
            }
        });
        this.m_Summary.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.m_ClassComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SetInstancesPanel.this.m_Instances != null && SetInstancesPanel.this.m_ClassComboBox.getSelectedIndex() != -1 && SetInstancesPanel.this.m_Instances.numAttributes() >= SetInstancesPanel.this.m_ClassComboBox.getSelectedIndex()) {
                    SetInstancesPanel.this.m_Instances.setClassIndex(SetInstancesPanel.this.m_ClassComboBox.getSelectedIndex() - 1);
                    SetInstancesPanel.this.m_Support.firePropertyChange("", null, null);
                }
            }
        });
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        panelButtons.add(this.m_OpenFileBut);
        panelButtons.add(this.m_OpenURLBut);
        JPanel panelClass = new JPanel(new FlowLayout(0));
        panelClass.add(this.m_ClassLabel);
        panelClass.add(this.m_ClassComboBox);
        if (this.m_showClassComboBox) {
            panelButtonsAndClass = new JPanel(new GridLayout(2, 1));
            panelButtonsAndClass.add(panelButtons);
            panelButtonsAndClass.add(panelClass);
        } else {
            panelButtonsAndClass = new JPanel(new GridLayout(1, 1));
            panelButtonsAndClass.add(panelButtons);
        }
        this.m_CloseButPanel = new JPanel(new FlowLayout(2));
        this.m_CloseButPanel.add(this.m_CloseBut);
        this.m_CloseButPanel.setVisible(false);
        JPanel panelButtonsAll = new JPanel(new BorderLayout());
        panelButtonsAll.add((Component)panelButtonsAndClass, "Center");
        panelButtonsAll.add((Component)this.m_CloseButPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Summary, "Center");
        this.add((Component)panelButtonsAll, "South");
    }

    public void setParentFrame(JFrame parent) {
        this.m_ParentFrame = parent;
        this.m_CloseButPanel.setVisible(this.m_ParentFrame != null);
    }

    public JFrame getParentFrame() {
        return this.m_ParentFrame;
    }

    public void closeFrame() {
        if (this.m_ParentFrame != null) {
            this.m_ParentFrame.setVisible(false);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int returnVal = this.m_FileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                final File selected = this.m_FileChooser.getSelectedFile();
                this.m_IOThread = new Thread(){

                    @Override
                    public void run() {
                        SetInstancesPanel.this.setInstancesFromFile(selected);
                        SetInstancesPanel.this.m_IOThread = null;
                    }
                };
                this.m_IOThread.setPriority(1);
                this.m_IOThread.start();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    public void setInstancesFromURLQ() {
        if (this.m_IOThread == null) {
            try {
                String urlName = (String)JOptionPane.showInputDialog(this, "Enter the source URL", "Load Instances", 3, null, null, this.m_LastURL);
                if (urlName != null) {
                    this.m_LastURL = urlName;
                    final URL url = new URL(urlName);
                    this.m_IOThread = new Thread(){

                        @Override
                        public void run() {
                            SetInstancesPanel.this.setInstancesFromURL(url);
                            SetInstancesPanel.this.m_IOThread = null;
                        }
                    };
                    this.m_IOThread.setPriority(1);
                    this.m_IOThread.start();
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Problem with URL:\n" + ex.getMessage(), "Load Instances", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Can't load at this time,\ncurrently busy with other IO", "Load Instances", 2);
        }
    }

    protected void setInstancesFromFile(File f) {
        boolean incremental = this.m_readIncrementally;
        try {
            this.m_Loader = this.m_FileChooser.getLoader();
            if (this.m_Loader == null) {
                throw new Exception("No suitable FileSourcedConverter found for file!\n" + f);
            }
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                incremental = false;
            }
            ((FileSourcedConverter)((Object)this.m_Loader)).setFile(f);
            if (incremental) {
                this.m_Summary.setShowZeroInstancesAsUnknown(this.m_showZeroInstancesAsUnknown);
                this.setInstances(this.m_Loader.getStructure());
            } else {
                this.m_Summary.setShowZeroInstancesAsUnknown(false);
                this.setInstances(this.m_Loader.getDataSet());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Couldn't read from file:\n" + f.getName(), "Load Instances", 0);
        }
    }

    protected void setInstancesFromURL(URL u) {
        boolean incremental = this.m_readIncrementally;
        try {
            this.m_Loader = ConverterUtils.getURLLoaderForFile(u.toString());
            if (this.m_Loader == null) {
                throw new Exception("No suitable URLSourcedLoader found for URL!\n" + u);
            }
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                incremental = false;
            }
            ((URLSourcedLoader)((Object)this.m_Loader)).setURL(u.toString());
            if (incremental) {
                this.m_Summary.setShowZeroInstancesAsUnknown(this.m_showZeroInstancesAsUnknown);
                this.setInstances(this.m_Loader.getStructure());
            } else {
                this.m_Summary.setShowZeroInstancesAsUnknown(false);
                this.setInstances(this.m_Loader.getDataSet());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Couldn't read from URL:\n" + u, "Load Instances", 0);
        }
    }

    public void setInstances(Instances i) {
        this.m_Instances = i;
        this.m_Summary.setInstances(this.m_Instances);
        if (this.m_showClassComboBox) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.m_ClassComboBox.getModel();
            model.removeAllElements();
            model.addElement(NO_CLASS);
            int n = 0;
            while (n < this.m_Instances.numAttributes()) {
                Attribute att = this.m_Instances.attribute(n);
                String type = "(" + Attribute.typeToStringShort(att) + ")";
                model.addElement(String.valueOf(type) + " " + att.name());
                ++n;
            }
            if (this.m_Instances.classIndex() == -1) {
                this.m_ClassComboBox.setSelectedIndex(this.m_Instances.numAttributes());
            } else {
                this.m_ClassComboBox.setSelectedIndex(this.m_Instances.classIndex() + 1);
            }
        }
        this.m_Support.firePropertyChange("", null, null);
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public int getClassIndex() {
        if (this.m_ClassComboBox.getSelectedIndex() <= 0) {
            return -1;
        }
        return this.m_ClassComboBox.getSelectedIndex() - 1;
    }

    public Loader getLoader() {
        return this.m_Loader;
    }

    public InstancesSummaryPanel getSummary() {
        return this.m_Summary;
    }

    public void setReadIncrementally(boolean incremental) {
        this.m_readIncrementally = incremental;
    }

    public boolean getReadIncrementally() {
        return this.m_readIncrementally;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }
}

