/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.Path;
import org.eclipse.epsilon.eol.IEolExecutableModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolClasspathNativeTypeDelegate;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.eunit.EUnitModule;
import org.eclipse.epsilon.eunit.EUnitTest;
import org.eclipse.epsilon.eunit.EUnitTestListener;
import org.eclipse.epsilon.eunit.EUnitTestResultType;
import org.eclipse.epsilon.workflow.tasks.ExecutableModuleTask;
import org.eclipse.epsilon.workflow.tasks.hosts.HostManager;

public class EUnitTask
extends ExecutableModuleTask
implements EUnitTestListener {
    private File fReportDirectory;
    private String fPackage = "default";
    private boolean fGenerateReport = true;
    private TaskCollection modelLoadingTasks;
    private ModelRepository oldProjectRepository;

    public EUnitTask() {
        this.setGUI(false);
    }

    @Override
    protected void initialize() throws Exception {
        EUnitModule eunitModule = (EUnitModule)this.module;
        eunitModule.addTestListener(this);
        eunitModule.setPackage(this.getPackage());
        if (this.getToDir() != null) {
            eunitModule.setReportDirectory(this.getToDir());
        } else if (this.isReport()) {
            eunitModule.setReportDirectory(this.getProject().getBaseDir());
        } else {
            eunitModule.setReportDirectory(null);
        }
        HostManager.getHost().addNativeTypeDelegates(eunitModule);
        List<EUnitTestListener> testListeners = HostManager.getHost().getExtensionsOfType(EUnitTestListener.class);
        for (EUnitTestListener listener : testListeners) {
            eunitModule.addTestListener(listener);
        }
    }

    @Override
    protected void examine() throws Exception {
        EUnitTest test = ((EUnitModule)this.createModule()).getSuiteRoot();
        PrintStream out = this.module.getContext().getOutputStream();
        out.println("Global result: " + (Object)((Object)test.getResult()));
        if (test.getResult() == EUnitTestResultType.FAILURE || test.getResult() == EUnitTestResultType.ERROR) {
            this.fail("At least one test case had a failure or an error: " + test.getException().getMessage(), test.getException());
        }
    }

    @Override
    public IEolExecutableModule createModule() {
        if (this.module == null) {
            this.module = new EUnitModule();
            IEolContext context = this.module.getContext();
            context.getOperationContributorRegistry().add(new RunTargetOperationContributor());
            context.getFrameStack().put(new Variable("antProject", this.getProject(), new EolAnyType(), true));
            AntClassLoader classLoaderAnt = this.getProject().createClassLoader(Path.systemClasspath);
            context.getNativeTypeDelegates().clear();
            context.getNativeTypeDelegates().add(new EolClasspathNativeTypeDelegate((ClassLoader)classLoaderAnt));
        }
        return this.module;
    }

    @Override
    public void beforeCase(EUnitModule module, EUnitTest test) {
        if (test.isRootTest()) {
            HostManager.getHost().configureUserInput(module, false);
        }
        if (test.isLeafTest()) {
            try {
                this.populateModelRepository(true);
            }
            catch (Exception e) {
                this.fail("Exception while repopulating the model repository", e);
            }
            this.oldProjectRepository = this.getProjectRepository();
            this.setProjectRepository(module.getContext().getModelRepository());
            if (this.modelLoadingTasks != null) {
                this.modelLoadingTasks.run();
            }
        }
    }

    @Override
    public void afterCase(EUnitModule module, EUnitTest test) {
        if (test.isLeafTest()) {
            this.setProjectRepository(this.oldProjectRepository);
            module.getContext().getModelRepository().dispose();
        }
        PrintStream out = module.getContext().getOutputStream();
        PrintStream err = module.getContext().getErrorStream();
        String sMillis = String.format(" [cpu: %d ms, wallclock: %d ms]", test.getCpuTimeMillis(), test.getWallclockTimeMillis());
        String testDescription = "Test " + test.getMethodName() + " {" + test.explainAllBindings() + "}";
        if (test.getResult() == EUnitTestResultType.SUCCESS) {
            out.println(String.valueOf(testDescription) + " passed" + sMillis);
        } else if (test.getResult() == EUnitTestResultType.SKIPPED) {
            out.println(String.valueOf(testDescription) + " skipped" + sMillis);
        } else {
            err.print(String.valueOf(testDescription) + " failed with status " + (Object)((Object)test.getResult()));
            Exception testException = test.getException();
            if (testException != null) {
                err.println(": " + testException.getMessage());
            } else {
                err.println();
            }
        }
    }

    public TaskCollection createModelTasks() {
        if (this.modelLoadingTasks == null) {
            this.modelLoadingTasks = new TaskCollection();
        }
        return this.modelLoadingTasks;
    }

    public File getToDir() {
        return this.fReportDirectory;
    }

    public void setToDir(File f) {
        this.fReportDirectory = f;
    }

    public String getPackage() {
        return this.fPackage;
    }

    public void setPackage(String packageName) {
        this.fPackage = packageName;
    }

    public boolean isReport() {
        return this.fGenerateReport;
    }

    public void setReport(boolean generate) {
        this.fGenerateReport = generate;
    }

    public class RunTargetOperationContributor
    extends OperationContributor {
        @Override
        public boolean contributesTo(Object target) {
            return EolNoType.NoInstance.equals(target);
        }

        public void runTarget(String targetName) throws EolRuntimeException {
            if (targetName == null) {
                throw new EolRuntimeException("The name of the target to be run cannot be null");
            }
            EUnitTask.this.getProject().executeTarget(targetName);
        }

        public void exportVariable(String varName) {
            EUnitTask.this.exportVariable(varName, varName, false, false);
        }

        public void useVariable(String varName) {
            EUnitTask.this.useVariable(varName, varName, false, false);
        }

        public void loadHutn(String modelName, String hutnContent) throws EolModelLoadingException {
            IModel hutnModel = null;
            try {
                Class<?> hutnModelClass = Class.forName("org.eclipse.epsilon.emc.hutn.HutnModel");
                Constructor<?> constructor = hutnModelClass.getConstructor(String.class, String.class);
                hutnModel = (IModel)constructor.newInstance(modelName, hutnContent);
                hutnModel.load();
                ModelRepository modelRepository = EUnitTask.this.module.getContext().getModelRepository();
                modelRepository.addModel(hutnModel);
            }
            catch (Exception ex) {
                throw new EolModelLoadingException(ex, hutnModel);
            }
        }
    }

    public class TaskCollection
    implements TaskContainer {
        private List<Task> tasks = new ArrayList<Task>();

        public void addTask(Task task) {
            this.tasks.add(task);
            if (task instanceof ExecutableModuleTask) {
                ExecutableModuleTask moduleTask = (ExecutableModuleTask)task;
                moduleTask.setGUI(EUnitTask.this.isGUI());
            }
        }

        public void run() {
            for (Task task : this.tasks) {
                task.perform();
            }
        }
    }
}

