/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.DefaultJAXPConfiguration;
import org.eclipse.xsd.util.JAXPConfiguration;
import org.eclipse.xsd.util.JAXPPool;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDParser
extends DefaultHandler
implements LexicalHandler {
    protected static final Map<Node, Map<Object, Object>> userDataMap = Collections.synchronizedMap(new WeakHashMap());
    protected XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    protected XSDSchema xsdSchema;
    protected List<XSDDiagnostic> xsdDiagnostics = new ArrayList<XSDDiagnostic>();
    protected SAXParser saxParser;
    protected JAXPPool jaxpPool;
    protected Document document;
    protected Stack<Element> stack = new Stack();
    protected Element element;
    protected Locator locator;
    protected int line;
    protected int column;
    protected String encoding;
    protected StringBuilder cdata;
    protected CDATASection cdataSection;

    static {
        new Flusher();
    }

    public static Map<Object, Object> getUserData(Node node) {
        return XSDParser.getLocationMap(node);
    }

    private static LocationMap getLocationMap(Node node) {
        LocationMap result = (LocationMap)userDataMap.get(node);
        if (result == null) {
            result = new LocationMap();
            userDataMap.put(node, result);
        }
        return result;
    }

    public static int getStartLine(Node node) {
        int result = XSDParser.getLocationMap(node).getStartLine();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static void setStartLine(Node node, int value) {
        XSDParser.getLocationMap(node).setStartLine(value);
    }

    public static int getStartColumn(Node node) {
        int result = XSDParser.getLocationMap(node).getStartColumn();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static void setStartColumn(Node node, int value) {
        XSDParser.getLocationMap(node).setStartColumn(value);
    }

    public static int getEndLine(Node node) {
        int result = XSDParser.getLocationMap(node).getEndLine();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static void setEndLine(Node node, int value) {
        XSDParser.getLocationMap(node).setEndLine(value);
    }

    public static int getEndColumn(Node node) {
        int result = XSDParser.getLocationMap(node).getEndColumn();
        return result == Integer.MAX_VALUE ? 1 : result;
    }

    public static void setEndColumn(Node node, int value) {
        XSDParser.getLocationMap(node).setEndColumn(value);
    }

    @Deprecated
    public XSDParser() {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(false);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.saxParser = saxParserFactory.newSAXParser();
            this.saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException exception) {
            this.fatalError(exception);
        }
        catch (ParserConfigurationException exception) {
            this.fatalError(exception);
        }
    }

    public XSDParser(Map<?, ?> options) {
        JAXPConfiguration config = null;
        if (options != null) {
            this.jaxpPool = (JAXPPool)options.get(XSDResourceImpl.XSD_JAXP_POOL);
            config = (JAXPConfiguration)options.get(XSDResourceImpl.XSD_JAXP_CONFIG);
        }
        try {
            this.saxParser = this.jaxpPool == null ? (config != null ? config.createSAXParser(this) : new DefaultJAXPConfiguration().createSAXParser(this)) : this.jaxpPool.getSAXParser(this);
        }
        catch (SAXException exception) {
            this.fatalError(exception);
        }
        catch (ParserConfigurationException exception) {
            this.fatalError(exception);
        }
    }

    public void parse(String uri) {
        try {
            try {
                this.saxParser.parse(new InputSource(uri), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
                if (this.jaxpPool != null) {
                    this.jaxpPool.releaseSAXParser(this.saxParser);
                }
            }
            catch (SAXException exception) {
                if (this.xsdDiagnostics.isEmpty()) {
                    this.fatalError(exception);
                }
                if (this.jaxpPool != null) {
                    this.jaxpPool.releaseSAXParser(this.saxParser);
                }
            }
        }
        finally {
            if (this.jaxpPool != null) {
                this.jaxpPool.releaseSAXParser(this.saxParser);
            }
        }
    }

    public void parseString(String input) {
        this.parse(new InputSource(new StringReader(input)));
    }

    public void parse(InputSource inputSource) {
        try {
            try {
                this.saxParser.parse(inputSource, (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
                if (this.jaxpPool != null) {
                    this.jaxpPool.releaseSAXParser(this.saxParser);
                }
            }
            catch (SAXException exception) {
                if (this.xsdDiagnostics.isEmpty()) {
                    this.fatalError(exception);
                }
                if (this.jaxpPool != null) {
                    this.jaxpPool.releaseSAXParser(this.saxParser);
                }
            }
        }
        finally {
            if (this.jaxpPool != null) {
                this.jaxpPool.releaseSAXParser(this.saxParser);
            }
        }
    }

    public void parse(InputStream inputStream) {
        try {
            try {
                this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
            }
            catch (IOException exception) {
                this.fatalError(exception);
                if (this.jaxpPool != null) {
                    this.jaxpPool.releaseSAXParser(this.saxParser);
                }
            }
            catch (SAXException exception) {
                if (this.xsdDiagnostics.isEmpty()) {
                    this.fatalError(exception);
                }
                if (this.jaxpPool != null) {
                    this.jaxpPool.releaseSAXParser(this.saxParser);
                }
            }
        }
        finally {
            if (this.jaxpPool != null) {
                this.jaxpPool.releaseSAXParser(this.saxParser);
            }
        }
    }

    public String getEncoding() {
        if (this.locator != null) {
            try {
                Method getEncodingMethod = this.locator.getClass().getMethod("getEncoding", new Class[0]);
                if (getEncodingMethod != null) {
                    this.encoding = (String)getEncodingMethod.invoke((Object)this.locator, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.encoding;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setSchema(XSDSchema xsdSchema) {
        if (this.document != null) {
            this.xsdSchema = xsdSchema;
            Element element = this.document.getDocumentElement();
            if (element != null) {
                xsdSchema.setElement(element);
            }
            xsdSchema.clearDiagnostics();
            XSDResourceImpl.assignDiagnostics(xsdSchema, this.xsdDiagnostics);
            XSDResourceImpl resource = (XSDResourceImpl)xsdSchema.eResource();
            if (resource != null && this.getEncoding() != null) {
                resource.getDefaultSaveOptions().put(XSDResourceImpl.XSD_ENCODING, this.getEncoding());
            }
        }
    }

    public XSDSchema getSchema() {
        if (this.xsdSchema == null && this.document != null) {
            Element element = this.document.getDocumentElement();
            this.xsdSchema = element == null ? this.xsdFactory.createXSDSchema() : XSDSchemaImpl.createSchema(element);
            XSDResourceImpl.assignDiagnostics(this.xsdSchema, this.xsdDiagnostics);
        }
        return this.xsdSchema;
    }

    public Collection<XSDDiagnostic> getDiagnostics() {
        return this.xsdDiagnostics;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        Element newElement = this.document.createElementNS(uri, qName);
        int i = 0;
        int length = attributes.getLength();
        while (i < length) {
            String attributeURI = attributes.getURI(i);
            String attributeQName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            if (attributeQName.equals("xmlns") || attributeQName.startsWith("xmlns:")) {
                attributeURI = "http://www.w3.org/2000/xmlns/";
            } else if ("".equals(attributeURI)) {
                attributeURI = null;
            }
            newElement.setAttributeNS(attributeURI, attributeQName, attributeValue);
            ++i;
        }
        if (this.stack.isEmpty()) {
            this.document.appendChild(newElement);
        } else {
            this.element.appendChild(newElement);
        }
        this.stack.push(this.element);
        this.element = newElement;
        LocationMap extendedAttributes = XSDParser.getLocationMap(this.element);
        extendedAttributes.setStartLine(this.line);
        extendedAttributes.setStartColumn(this.column);
        this.saveLocation();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.saveLocation();
        LocationMap extendedAttributes = XSDParser.getLocationMap(this.element);
        extendedAttributes.setEndLine(this.line);
        extendedAttributes.setEndColumn(this.column);
        this.element = this.stack.pop();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() {
        this.saveLocation();
        this.document = XSDParser.createDocument();
        this.xsdSchema = null;
        this.stack.clear();
        this.getEncoding();
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException exception) {
            XSDPlugin.INSTANCE.log(exception);
            return null;
        }
    }

    @Override
    public void endDocument() {
        this.element = null;
        this.saveLocation();
        this.locator = null;
    }

    @Override
    public void characters(char[] characters, int start, int length) throws SAXException {
        if (this.cdata != null) {
            this.cdata.append(characters, start, length);
        } else {
            int lineFeed = 0;
            int carriageReturn = 0;
            int i = 0;
            while (i < length) {
                char character = characters[start + i];
                if (character == '\n') {
                    ++lineFeed;
                    this.column = 1;
                } else if (character == '\r') {
                    ++carriageReturn;
                    this.column = 1;
                } else if (character == ' ' && character == '\t') {
                    ++this.column;
                } else {
                    Text textNode;
                    if (i != 0) {
                        textNode = this.document.createTextNode(new String(characters, start, i));
                        this.element.appendChild(textNode);
                    }
                    this.line += Math.max(lineFeed, carriageReturn);
                    textNode = this.document.createTextNode(new String(characters, start + i, length - i));
                    this.element.appendChild(textNode);
                    LocationMap extendedAttributes = XSDParser.getLocationMap(textNode);
                    extendedAttributes.setStartLine(this.line);
                    extendedAttributes.setStartColumn(this.column);
                    this.saveLocation();
                    extendedAttributes.setEndLine(this.line);
                    extendedAttributes.setEndColumn(this.column);
                    return;
                }
                ++i;
            }
            Text textNode = this.document.createTextNode(new String(characters, start, length));
            this.element.appendChild(textNode);
            this.saveLocation();
        }
    }

    @Override
    public void comment(char[] characters, int start, int length) throws SAXException {
        Comment commentNode = this.document.createComment(new String(characters, start, length));
        if (this.element == null) {
            this.document.appendChild(commentNode);
        } else {
            this.element.appendChild(commentNode);
        }
        this.saveLocation();
    }

    @Override
    public void startCDATA() {
        this.cdata = new StringBuilder();
        this.cdataSection = this.document.createCDATASection("");
        LocationMap extendedAttributes = XSDParser.getLocationMap(this.cdataSection);
        extendedAttributes.setStartLine(this.line);
        extendedAttributes.setStartColumn(this.column);
    }

    @Override
    public void endCDATA() {
        this.cdataSection.setData(this.cdata.toString());
        this.element.appendChild(this.cdataSection);
        LocationMap extendedAttributes = XSDParser.getLocationMap(this.cdataSection);
        this.cdata = null;
        this.saveLocation();
        extendedAttributes.setEndLine(this.line);
        extendedAttributes.setEndColumn(this.column);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(target, data);
        if (this.stack.isEmpty()) {
            this.document.appendChild(processingInstruction);
        } else {
            this.element.appendChild(processingInstruction);
        }
    }

    protected void fatalError(IOException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void fatalError(ParserConfigurationException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getLocalizedMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    public void fatalError(SAXException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.FATAL_LITERAL);
        xsdDiagnostic.setMessage(XSDPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    @Override
    public void error(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.ERROR_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    @Override
    public void warning(SAXParseException exception) {
        XSDDiagnostic xsdDiagnostic = this.xsdFactory.createXSDDiagnostic();
        xsdDiagnostic.setSeverity(XSDDiagnosticSeverity.WARNING_LITERAL);
        xsdDiagnostic.setMessage("DOM:" + exception.getMessage());
        xsdDiagnostic.setLine(exception.getLineNumber());
        xsdDiagnostic.setColumn(exception.getColumnNumber());
        this.xsdDiagnostics.add(xsdDiagnostic);
    }

    protected void saveLocation() {
        if (this.locator != null) {
            this.line = this.locator.getLineNumber();
            this.column = this.locator.getColumnNumber();
            if (this.column == -1) {
                this.column = 1;
            }
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource inputSource;
        if ("-//W3C//DTD XMLSCHEMA 200102//EN".equalsIgnoreCase(publicId)) {
            inputSource = new InputSource(XSDPlugin.INSTANCE.getBaseURL() + "cache/www.w3.org/2001/XMLSchema.dtd");
            inputSource.setPublicId(publicId);
        } else if (systemId != null && systemId.startsWith("file://bundleentry:")) {
            inputSource = new InputSource(systemId.substring(7));
            inputSource.setPublicId(publicId);
        } else {
            try {
                inputSource = super.resolveEntity(publicId, systemId);
            }
            catch (IOException exception) {
                throw new SAXException(exception);
            }
        }
        return inputSource;
    }

    private static class Flusher {
        private Flusher() {
        }

        protected void finalize() throws Throwable {
            userDataMap.size();
            new Flusher();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocationMap
    extends AbstractMap<Object, Object> {
        protected static final int UNSET = Integer.MAX_VALUE;
        protected Map<Object, Object> delegateMap;
        private int startLine = Integer.MAX_VALUE;
        private int startColumn = Integer.MAX_VALUE;
        private int endLine = Integer.MAX_VALUE;
        private int endColumn = Integer.MAX_VALUE;

        private LocationMap() {
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.getDelegateMap().entrySet();
        }

        protected Map<Object, Object> getDelegateMap() {
            if (this.delegateMap == null) {
                this.delegateMap = new HashMap<Object, Object>();
                if (this.startLine != Integer.MAX_VALUE) {
                    this.delegateMap.put("startLine", this.startLine);
                }
                if (this.startColumn != Integer.MAX_VALUE) {
                    this.delegateMap.put("startColumn", this.startColumn);
                }
                if (this.endLine != Integer.MAX_VALUE) {
                    this.delegateMap.put("endLine", this.endLine);
                }
                if (this.endColumn != Integer.MAX_VALUE) {
                    this.delegateMap.put("endColumn", this.endColumn);
                }
            }
            return this.delegateMap;
        }

        protected int objectToInt(Object value) {
            return value == null ? Integer.MAX_VALUE : (Integer)value;
        }

        protected Object intToObject(int value) {
            return value == Integer.MAX_VALUE ? null : Integer.valueOf(value);
        }

        @Override
        public Object put(Object key, Object value) {
            Object result;
            if (this.delegateMap == null) {
                if ("startLine".equals(key)) {
                    result = this.intToObject(this.startLine);
                    this.startLine = this.objectToInt(value);
                } else if ("endLine".equals(key)) {
                    result = this.intToObject(this.endLine);
                    this.endLine = this.objectToInt(value);
                } else if ("startColumn".equals(key)) {
                    result = this.intToObject(this.startColumn);
                    this.startColumn = this.objectToInt(value);
                } else if ("endColumn".equals(key)) {
                    result = this.intToObject(this.endColumn);
                    this.endColumn = this.objectToInt(value);
                } else {
                    result = this.getDelegateMap().put(key, value);
                }
            } else {
                result = this.getDelegateMap().put(key, value);
            }
            return result;
        }

        public int getStartLine() {
            return this.delegateMap == null ? this.startLine : this.objectToInt(this.delegateMap.get("startLine"));
        }

        public void setStartLine(int startLine) {
            if (this.delegateMap == null) {
                this.startLine = startLine;
            } else {
                this.delegateMap.put("startLine", startLine);
            }
        }

        public int getStartColumn() {
            return this.delegateMap == null ? this.startColumn : this.objectToInt(this.delegateMap.get("startColumn"));
        }

        public void setStartColumn(int startColumn) {
            if (this.delegateMap == null) {
                this.startColumn = startColumn;
            } else {
                this.delegateMap.put("startColumn", startColumn);
            }
        }

        public int getEndLine() {
            return this.delegateMap == null ? this.endLine : this.objectToInt(this.delegateMap.get("endLine"));
        }

        public void setEndLine(int endLine) {
            if (this.delegateMap == null) {
                this.endLine = endLine;
            } else {
                this.delegateMap.put("endLine", endLine);
            }
        }

        public int getEndColumn() {
            return this.delegateMap == null ? this.endColumn : this.objectToInt(this.delegateMap.get("endColumn"));
        }

        public void setEndColumn(int endColumn) {
            if (this.delegateMap == null) {
                this.endColumn = endColumn;
            } else {
                this.delegateMap.put("endColumn", endColumn);
            }
        }
    }
}

