/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;

public class LabelList {
    public static final ByteBufferSerializer<LabelList> SERIALIZER = new Serializer();
    private String[] labels;
    public static final LabelList EMPTY_LABELS = new LabelList(0);

    private LabelList(int n) {
        this.labels = new String[n];
    }

    protected LabelList(String[] stringArray) {
        this.labels = stringArray;
    }

    public static LabelList make(Collection<String> collection) {
        int n = collection.size();
        if (n == 0) {
            return EMPTY_LABELS;
        }
        return new LabelList(collection.toArray(new String[n]));
    }

    public int size() {
        return this.labels.length;
    }

    public String get(int n) {
        return this.labels[n];
    }

    public String toString() {
        return FormatUtil.format(this.labels, " ");
    }

    public static class Serializer
    implements ByteBufferSerializer<LabelList> {
        @Override
        public LabelList fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            LabelList labelList = new LabelList(n);
            for (int i = 0; i < n; ++i) {
                ((LabelList)labelList).labels[i] = ByteArrayUtil.STRING_SERIALIZER.fromByteBuffer(byteBuffer);
            }
            return labelList;
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, LabelList labelList) throws IOException {
            int n = labelList.labels.length;
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, n);
            for (int i = 0; i < n; ++i) {
                ByteArrayUtil.STRING_SERIALIZER.toByteBuffer(byteBuffer, labelList.labels[i]);
            }
        }

        @Override
        public int getByteSize(LabelList labelList) throws IOException {
            int n = labelList.labels.length;
            int n2 = ByteArrayUtil.getUnsignedVarintSize(n);
            for (int i = 0; i < n; ++i) {
                n2 += ByteArrayUtil.STRING_SERIALIZER.getByteSize(labelList.labels[i]);
            }
            return n2;
        }
    }
}

