/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality;

import de.lmu.ifi.dbs.elki.math.statistics.ProbabilityWeightedMoments;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AbstractIntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class LMomentsEstimator
extends AbstractIntrinsicDimensionalityEstimator {
    public static final LMomentsEstimator STATIC = new LMomentsEstimator();

    @Override
    public <A> double estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
        if (n < 2) {
            throw new ArithmeticException("ID estimates require at least 2 non-zero distances");
        }
        if (n == 2) {
            double d = numberArrayAdapter.getDouble(a, 0) / numberArrayAdapter.getDouble(a, 1);
            return d / (1.0 - d);
        }
        int n2 = n - 1;
        double d = numberArrayAdapter.getDouble(a, n2);
        double[] dArray = ProbabilityWeightedMoments.samLMR(a, new ReverseAdapter<A>(numberArrayAdapter, n), 2);
        if (dArray[1] == 0.0) {
            return -0.5 * (dArray[0] * 2.0) / d * ((double)n + 0.5) * (double)n;
        }
        return -0.5 * (dArray[0] * dArray[0] / dArray[1] - dArray[0]) / d;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LMomentsEstimator makeInstance() {
            return STATIC;
        }
    }

    private static class ReverseAdapter<A>
    implements NumberArrayAdapter<Double, A> {
        private int s;
        private NumberArrayAdapter<?, A> inner;

        public ReverseAdapter(NumberArrayAdapter<?, A> numberArrayAdapter, int n) {
            this.inner = numberArrayAdapter;
            this.s = n - 1;
        }

        @Override
        public int size(A a) {
            return this.s + 1;
        }

        @Override
        public Double get(A a, int n) throws IndexOutOfBoundsException {
            return this.inner.getDouble(a, this.s - n);
        }

        @Override
        public double getDouble(A a, int n) throws IndexOutOfBoundsException {
            return this.inner.getDouble(a, this.s - n);
        }

        @Override
        public float getFloat(A a, int n) throws IndexOutOfBoundsException {
            return this.inner.getFloat(a, this.s - n);
        }

        @Override
        public int getInteger(A a, int n) throws IndexOutOfBoundsException {
            return this.inner.getInteger(a, this.s - n);
        }

        @Override
        public short getShort(A a, int n) throws IndexOutOfBoundsException {
            return this.inner.getShort(a, this.s - n);
        }

        @Override
        public long getLong(A a, int n) throws IndexOutOfBoundsException {
            return this.inner.getLong(a, this.s - n);
        }

        @Override
        public byte getByte(A a, int n) throws IndexOutOfBoundsException {
            return this.inner.getByte(a, this.s - n);
        }
    }
}

