/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.projections;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.visualization.projections.ProjectionParallel;
import de.lmu.ifi.dbs.elki.visualization.projector.Projector;

public class SimpleParallel
implements ProjectionParallel {
    int visDims;
    byte[] flags;
    int[] dimOrder;
    private LinearScale[] scales;
    private Projector p;
    static final byte FLAG_HIDDEN = 1;
    static final byte FLAG_INVERTED = 2;

    public SimpleParallel(Projector projector, LinearScale[] linearScaleArray) {
        this.p = projector;
        this.scales = linearScaleArray;
        this.visDims = linearScaleArray.length;
        this.flags = new byte[linearScaleArray.length];
        this.dimOrder = new int[linearScaleArray.length];
        for (int i = 0; i < this.dimOrder.length; ++i) {
            this.dimOrder[i] = i;
        }
    }

    @Override
    public LinearScale getScale(int n) {
        return this.scales[n];
    }

    @Override
    public boolean isAxisInverted(int n) {
        return this.isDimInverted(this.dimOrder[n]);
    }

    @Override
    public void setAxisInverted(int n, boolean bl) {
        this.setDimInverted(this.dimOrder[n], bl);
    }

    @Override
    public void toggleAxisInverted(int n) {
        this.toggleDimInverted(this.dimOrder[n]);
    }

    @Override
    public boolean isDimInverted(int n) {
        return (this.flags[n] & 2) == 2;
    }

    @Override
    public void setDimInverted(int n, boolean bl) {
        if (bl) {
            int n2 = n;
            this.flags[n2] = (byte)(this.flags[n2] | 2);
        } else {
            int n3 = n;
            this.flags[n3] = (byte)(this.flags[n3] & 0xFFFFFFFD);
        }
    }

    @Override
    public void toggleDimInverted(int n) {
        int n2 = n;
        this.flags[n2] = (byte)(this.flags[n2] ^ 2);
    }

    @Override
    public LinearScale getAxisScale(int n) {
        return this.scales[this.dimOrder[n]];
    }

    protected boolean isDimHidden(int n) {
        return (this.flags[n] & 1) == 1;
    }

    @Override
    public boolean isAxisVisible(int n) {
        return !this.isDimHidden(this.dimOrder[n]);
    }

    @Override
    public void setAxisVisible(int n, boolean bl) {
        boolean bl2 = this.isAxisVisible(n);
        if (bl2 == bl) {
            return;
        }
        if (bl) {
            int n2 = this.dimOrder[n];
            this.flags[n2] = (byte)(this.flags[n2] & 0xFFFFFFFE);
            ++this.visDims;
        } else {
            int n3 = this.dimOrder[n];
            this.flags[n3] = (byte)(this.flags[n3] | 1);
            --this.visDims;
        }
    }

    @Override
    public void toggleAxisVisible(int n) {
        boolean bl = this.isAxisVisible(n);
        if (!bl) {
            int n2 = this.dimOrder[n];
            this.flags[n2] = (byte)(this.flags[n2] & 0xFFFFFFFE);
            ++this.visDims;
        } else {
            int n3 = this.dimOrder[n];
            this.flags[n3] = (byte)(this.flags[n3] | 1);
            --this.visDims;
        }
    }

    @Override
    public int getVisibleDimensions() {
        return this.visDims;
    }

    @Override
    public int getDimForAxis(int n) {
        return this.dimOrder[n];
    }

    @Override
    public int getDimForVisibleAxis(int n) {
        for (int i = 0; i < this.scales.length; ++i) {
            if (this.isDimHidden(this.dimOrder[i])) continue;
            if (n == 0) {
                return this.dimOrder[i];
            }
            --n;
        }
        return -1;
    }

    @Override
    public void swapAxes(int n, int n2) {
        int n3 = this.dimOrder[n];
        this.dimOrder[n] = this.dimOrder[n2];
        this.dimOrder[n2] = n3;
    }

    @Override
    public void moveAxis(int n, int n2) {
        if (n > n2) {
            int n3 = this.dimOrder[n];
            System.arraycopy(this.dimOrder, n2, this.dimOrder, n2 + 1, n - n2);
            this.dimOrder[n2] = n3;
        } else if (n < n2) {
            int n4 = this.dimOrder[n];
            System.arraycopy(this.dimOrder, n + 1, this.dimOrder, n, n2 - n);
            this.dimOrder[n2 - 1] = n4;
        }
    }

    @Override
    public double[] fastProjectDataToRenderSpace(NumberVector numberVector) {
        double[] dArray = new double[this.visDims];
        int n = 0;
        for (int i = 0; i < this.scales.length; ++i) {
            if (this.isDimHidden(i)) continue;
            int n2 = this.dimOrder[i];
            double d = this.scales[n2].getScaled(numberVector.doubleValue(n2));
            d = this.isDimInverted(n2) ? d : 1.0 - d;
            dArray[n++] = d * 100.0;
        }
        return dArray;
    }

    @Override
    public double[] fastProjectDataToRenderSpace(double[] dArray) {
        double[] dArray2 = new double[this.visDims];
        int n = 0;
        for (int i = 0; i < this.scales.length; ++i) {
            if (this.isDimHidden(i)) continue;
            int n2 = this.dimOrder[i];
            double d = this.scales[n2].getScaled(dArray[n2]);
            d = this.isDimInverted(n2) ? d : 1.0 - d;
            dArray2[n++] = d * 100.0;
        }
        return dArray2;
    }

    @Override
    public double fastProjectRenderToDataSpace(double d, int n) {
        int n2 = this.dimOrder[n];
        d = this.isDimInverted(n2) ? d : 1.0 - (d /= 100.0);
        return this.scales[n2].getUnscaled(d);
    }

    @Override
    public double fastProjectDataToRenderSpace(double d, int n) {
        double d2 = this.scales[this.dimOrder[n]].getScaled(d);
        return this.isAxisInverted(this.dimOrder[n]) ? 1.0 - d2 : (d2 *= 100.0);
    }

    @Override
    public int getAxisForDim(int n) {
        for (int i = 0; i < this.dimOrder.length; ++i) {
            if (this.dimOrder[i] != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getInputDimensionality() {
        return this.scales.length;
    }

    @Override
    public String getMenuName() {
        return "Parallel Coordinates";
    }

    @Override
    public Projector getProjector() {
        return this.p;
    }
}

