/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClassManager;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGSimpleLinearAxis;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import org.w3c.dom.Element;

public class OPTICSPlotVisualizer
extends AbstractVisFactory {
    private static final String NAME = "OPTICS Plot";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<OPTICSProjector> iter = VisualizationTree.filter(visualizerContext, object, OPTICSProjector.class);
        while (iter.valid()) {
            OPTICSProjector oPTICSProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, oPTICSProjector.getResult(), null, this);
            visualizationTask.level = 100;
            visualizerContext.addVis(oPTICSProjector, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization {
        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            OPTICSPlot oPTICSPlot = this.optics.getOPTICSPlot(this.context);
            String string = oPTICSPlot.getSVGPlotURI();
            Element element = this.svgp.svgElement("image");
            SVGUtil.setAtt(element, "preserveAspectRatio", "none");
            SVGUtil.setAtt(element, "image-rendering", "optimizeSpeed");
            SVGUtil.setAtt(element, "x", 0);
            SVGUtil.setAtt(element, "y", 0);
            SVGUtil.setAtt(element, "width", this.plotwidth);
            SVGUtil.setAtt(element, "height", this.plotheight);
            element.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", string);
            this.layer.appendChild(element);
            LinearScale linearScale = oPTICSPlot.getScale();
            double d = this.plotheight * (double)oPTICSPlot.scaleToPixel(linearScale.getMin()) / (double)oPTICSPlot.getHeight();
            double d2 = this.plotheight * (double)oPTICSPlot.scaleToPixel(linearScale.getMax()) / (double)oPTICSPlot.getHeight();
            try {
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, linearScale, 0.0, d, 0.0, d2, SVGSimpleLinearAxis.LabelStyle.LEFTHAND, styleLibrary);
                SVGSimpleLinearAxis.drawAxis(this.svgp, this.layer, linearScale, this.plotwidth, d, this.plotwidth, d2, SVGSimpleLinearAxis.LabelStyle.RIGHTHAND, styleLibrary);
            }
            catch (CSSClassManager.CSSNamingConflict cSSNamingConflict) {
                LoggingUtil.exception("CSS naming conflict for axes on OPTICS plot", cSSNamingConflict);
            }
        }
    }
}

