/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.OPTICSXi;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import java.awt.Color;
import org.w3c.dom.Element;

public class OPTICSSteepAreaVisualization
extends AbstractVisFactory {
    private static final String NAME = "OPTICS Steep Areas";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<OPTICSProjector> iter = VisualizationTree.filter(visualizerContext, object, OPTICSProjector.class);
        while (iter.valid()) {
            OPTICSProjector oPTICSProjector = iter.get();
            OPTICSXi.SteepAreaResult steepAreaResult = OPTICSSteepAreaVisualization.findSteepAreaResult(oPTICSProjector.getResult());
            if (steepAreaResult != null) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, oPTICSProjector.getResult(), null, this);
                visualizationTask.level = 101;
                visualizerContext.addVis(oPTICSProjector, visualizationTask);
                visualizerContext.addVis(steepAreaResult, visualizationTask);
            }
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    protected static OPTICSXi.SteepAreaResult findSteepAreaResult(ClusterOrder clusterOrder) {
        Hierarchy.Iter<ClusterOrder> iter = clusterOrder.getHierarchy().iterChildren(clusterOrder);
        while (iter.valid()) {
            if (OPTICSXi.SteepAreaResult.class.isInstance(iter.get())) {
                return (OPTICSXi.SteepAreaResult)((Object)iter.get());
            }
            iter.advance();
        }
        return null;
    }

    public class Instance
    extends AbstractOPTICSVisualization {
        protected static final String CSS_STEEP_UP = "opticsSteepUp";
        protected static final String CSS_STEEP_DOWN = "opticsSteepDown";
        OPTICSXi.SteepAreaResult areas;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.areas = OPTICSSteepAreaVisualization.findSteepAreaResult(this.optics.getResult());
        }

        @Override
        public void fullRedraw() {
            this.makeLayerElement();
            this.addCSSClasses();
            OPTICSPlot oPTICSPlot = this.optics.getOPTICSPlot(this.context);
            ClusterOrder clusterOrder = this.getClusterOrder();
            int n = oPTICSPlot.getHeight();
            double d = this.plotwidth / (double)clusterOrder.size();
            double d2 = this.plotheight / (double)n;
            DBIDArrayIter dBIDArrayIter = clusterOrder.iter();
            for (OPTICSXi.SteepArea steepArea : this.areas) {
                int n2 = steepArea.getStartIndex();
                int n3 = steepArea.getEndIndex();
                double d3 = (double)n2 + 0.25;
                double d4 = (double)n3 + 0.75;
                double d5 = oPTICSPlot.scaleToPixel(clusterOrder.getReachability(dBIDArrayIter.seek(n2)));
                double d6 = oPTICSPlot.scaleToPixel(clusterOrder.getReachability(dBIDArrayIter.seek(n3)));
                Element element = this.svgp.svgLine(d3 * d, d5 * d2, d4 * d, d6 * d2);
                if (steepArea instanceof OPTICSXi.SteepDownArea) {
                    SVGUtil.addCSSClass(element, CSS_STEEP_DOWN);
                } else {
                    SVGUtil.addCSSClass(element, CSS_STEEP_UP);
                }
                this.layer.appendChild(element);
            }
        }

        private void addCSSClasses() {
            Color color;
            CSSClass cSSClass;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!this.svgp.getCSSClassManager().contains(CSS_STEEP_DOWN)) {
                cSSClass = new CSSClass(this, CSS_STEEP_DOWN);
                color = SVGUtil.stringToColor(styleLibrary.getColor("plot"));
                if (color == null) {
                    color = Color.BLACK;
                }
                color = new Color((int)((double)color.getRed() * 0.6), (int)((double)color.getGreen() * 0.6 + 102.4), (int)((double)color.getBlue() * 0.6));
                cSSClass.setStatement("stroke", SVGUtil.colorToString(color));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 0.5);
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_STEEP_UP)) {
                cSSClass = new CSSClass(this, CSS_STEEP_UP);
                color = SVGUtil.stringToColor(styleLibrary.getColor("plot"));
                if (color == null) {
                    color = Color.BLACK;
                }
                color = new Color((int)((double)color.getRed() * 0.6 + 102.4), (int)((double)color.getGreen() * 0.6), (int)((double)color.getBlue() * 0.6));
                cSSClass.setStatement("stroke", SVGUtil.colorToString(color));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 0.5);
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

