/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.MathCommand;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Equals
extends MathCommand
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.9 $";
    private Class m_type;

    public Equals(GPConfiguration a_conf, Class a_type) throws InvalidConfigurationException {
        this(a_conf, a_type, 0, null);
    }

    public Equals(GPConfiguration a_conf, Class a_type, int a_subReturnType, int[] a_subChildTypes) throws InvalidConfigurationException {
        super(a_conf, 2, CommandGene.BooleanClass, a_subReturnType, a_subChildTypes);
        this.m_type = a_type;
    }

    public String toString() {
        return "Equals(&1, &2)";
    }

    public String getName() {
        return "Equals";
    }

    public boolean execute_boolean(ProgramChromosome c, int n, Object[] args) {
        if (this.m_type == CommandGene.BooleanClass) {
            return c.execute_boolean(n, 0, args) == c.execute_boolean(n, 1, args);
        }
        if (this.m_type == CommandGene.IntegerClass) {
            return c.execute_int(n, 0, args) == c.execute_int(n, 1, args);
        }
        if (this.m_type == CommandGene.LongClass) {
            return c.execute_long(n, 0, args) == c.execute_long(n, 1, args);
        }
        if (this.m_type == CommandGene.DoubleClass) {
            return Math.abs(c.execute_double(n, 0, args) - c.execute_double(n, 1, args)) < 1.0E-7;
        }
        if (this.m_type == CommandGene.FloatClass) {
            return (double)Math.abs(c.execute_float(n, 0, args) - c.execute_float(n, 1, args)) < 1.0E-7;
        }
        if (this.m_type == CommandGene.VoidClass) {
            return c.execute_object(n, 0, args).equals(c.execute_object(n, 1, args));
        }
        throw new UnsupportedOperationException("Unsupported type " + this.m_type + " for Equals-command!");
    }

    public Class getChildType(IGPProgram a_ind, int a_index) {
        return this.m_type;
    }

    public Object clone() {
        try {
            Equals result = new Equals(this.getGPConfiguration(), this.m_type, this.getSubReturnType(), this.getSubChildTypes());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    public boolean equals(Object a_other) {
        if (a_other == null || !(a_other instanceof Equals)) {
            return false;
        }
        if (!super.equals(a_other)) {
            return false;
        }
        Equals other = (Equals)a_other;
        return new EqualsBuilder().append((Object)this.m_type, (Object)other.m_type).isEquals();
    }
}

