/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function.statistics;

import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandDynamicArity;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Skewness
extends CommandDynamicArity
implements ICloneable {
    public Skewness(GPConfiguration a_conf, Class a_returnType, int a_arityInitial, int a_arityMin, int a_arityMax) throws InvalidConfigurationException {
        super(a_conf, a_arityInitial + 1, a_arityMin + 1, a_arityMax + 1, a_returnType);
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        int size = this.size();
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < size; ++i) {
            stats.addValue(c.execute_double(n, i, args));
        }
        return stats.getSkewness();
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        int size = this.size();
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < size; ++i) {
            stats.addValue((double)c.execute_float(n, i, args));
        }
        return (float)stats.getSkewness();
    }

    public String toString() {
        String s = "Skewness(";
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                s = s + ";";
            }
            s = s + "&" + (i + 1);
        }
        return s + ")";
    }

    public Object clone() {
        try {
            Skewness result = new Skewness(this.getGPConfiguration(), this.getReturnType(), this.getArity(null), this.getArityMin(), this.getArityMax());
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }

    public String getName() {
        return "Skewness";
    }
}

