/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.terminal;

import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Terminal
extends CommandGene
implements IMutateable,
ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.18 $";
    private float m_value_float;
    private double m_value_double;
    private int m_value_int;
    private long m_value_long;
    private double m_lowerBounds;
    private double m_upperBounds;
    private boolean m_wholeNumbers;

    public Terminal() throws InvalidConfigurationException {
        this(GPGenotype.getStaticGPConfiguration(), CommandGene.IntegerClass);
    }

    public Terminal(GPConfiguration a_conf, Class a_returnType) throws InvalidConfigurationException {
        this(a_conf, a_returnType, 0.0, 99.0, false);
    }

    public Terminal(GPConfiguration a_conf, Class a_returnType, double a_minValue, double a_maxValue) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_minValue, a_maxValue, false);
    }

    public Terminal(GPConfiguration a_conf, Class a_returnType, double a_minValue, double a_maxValue, boolean a_wholeNumbers) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_minValue, a_maxValue, a_wholeNumbers, 0);
    }

    public Terminal(GPConfiguration a_conf, Class a_returnType, double a_minValue, double a_maxValue, boolean a_wholeNumbers, int a_subReturnType) throws InvalidConfigurationException {
        this(a_conf, a_returnType, a_minValue, a_maxValue, a_wholeNumbers, a_subReturnType, true);
    }

    public Terminal(GPConfiguration a_conf, Class a_returnType, double a_minValue, double a_maxValue, boolean a_wholeNumbers, int a_subReturnType, boolean a_randomize) throws InvalidConfigurationException {
        super(a_conf, 0, a_returnType, a_subReturnType, null);
        this.m_lowerBounds = a_minValue;
        this.m_upperBounds = a_maxValue;
        this.m_wholeNumbers = a_wholeNumbers;
        if (a_randomize) {
            this.setRandomValue();
        }
    }

    protected void setRandomValue(int a_value) {
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        this.m_value_int = (int)Math.round(randomGen.nextDouble() * (this.m_upperBounds - this.m_lowerBounds) + this.m_lowerBounds);
    }

    protected void setRandomValue(long a_value) {
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        this.m_value_long = Math.round(randomGen.nextDouble() * (this.m_upperBounds - this.m_lowerBounds) + this.m_lowerBounds);
    }

    protected void setRandomValue(double a_value) {
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        this.m_value_double = randomGen.nextDouble() * (this.m_upperBounds - this.m_lowerBounds) + this.m_lowerBounds;
        if (this.m_wholeNumbers) {
            this.m_value_double = Math.round(this.m_value_double);
        }
    }

    protected void setRandomValue(float a_value) {
        RandomGenerator randomGen = this.getGPConfiguration().getRandomGenerator();
        this.m_value_float = (float)((double)randomGen.nextFloat() * (this.m_upperBounds - this.m_lowerBounds) + this.m_lowerBounds);
        if (this.m_wholeNumbers) {
            this.m_value_float = Math.round(this.m_value_float);
        }
    }

    protected void setRandomValue() {
        Class retType = this.getReturnType();
        if (retType == CommandGene.FloatClass || retType == Float.TYPE) {
            this.setRandomValue(this.m_value_float);
        } else if (retType == CommandGene.IntegerClass || retType == Integer.TYPE) {
            this.setRandomValue(this.m_value_int);
        } else if (retType == CommandGene.LongClass || retType == Long.TYPE) {
            this.setRandomValue(this.m_value_long);
        } else if (retType == CommandGene.DoubleClass || retType == Double.TYPE) {
            this.setRandomValue(this.m_value_double);
        } else {
            throw new RuntimeException("unknown terminal type: " + retType);
        }
    }

    public void setValue(double a_value) {
        this.m_value_double = this.m_wholeNumbers ? (double)Math.round(a_value) : a_value;
    }

    public void setValue(float a_value) {
        this.m_value_float = this.m_wholeNumbers ? (float)Math.round(a_value) : a_value;
    }

    public void setValue(int a_value) {
        this.m_value_int = a_value;
    }

    public void setValue(long a_value) {
        this.m_value_long = a_value;
    }

    public CommandGene applyMutation(int index, double a_percentage) throws InvalidConfigurationException {
        if (a_percentage > 0.85) {
            this.setRandomValue();
        } else {
            Class retType = this.getReturnType();
            if (retType == CommandGene.FloatClass) {
                float rangef = ((float)this.m_upperBounds - (float)this.m_lowerBounds) * (float)a_percentage;
                float newValuef = (double)this.m_value_float >= (this.m_upperBounds - this.m_lowerBounds) / 2.0 ? this.m_value_float - this.getGPConfiguration().getRandomGenerator().nextFloat() * rangef : this.m_value_float + this.getGPConfiguration().getRandomGenerator().nextFloat() * rangef;
                if (this.m_lowerBounds - (double)newValuef > 1.0E-7 || (double)newValuef - this.m_upperBounds > 1.0E-7) {
                    this.setRandomValue(this.m_value_float);
                } else {
                    this.setValue(newValuef);
                }
            } else if (retType == CommandGene.DoubleClass) {
                double rangeD = (this.m_upperBounds - this.m_lowerBounds) * a_percentage;
                double newValueD = this.m_value_double >= (this.m_upperBounds - this.m_lowerBounds) / 2.0 ? this.m_value_double - (double)this.getGPConfiguration().getRandomGenerator().nextFloat() * rangeD : this.m_value_double + (double)this.getGPConfiguration().getRandomGenerator().nextFloat() * rangeD;
                if (this.m_lowerBounds - newValueD > 1.0E-7 || newValueD - this.m_upperBounds > 1.0E-7) {
                    this.setRandomValue(this.m_value_float);
                } else {
                    this.setValue(newValueD);
                }
            } else if (retType == CommandGene.IntegerClass) {
                double range = (this.m_upperBounds - this.m_lowerBounds) * a_percentage;
                int newValueI = (double)this.m_value_int >= (this.m_upperBounds - this.m_lowerBounds) / 2.0 ? this.m_value_int - (int)Math.round((double)this.getGPConfiguration().getRandomGenerator().nextInt() * range) : this.m_value_int + (int)Math.round((double)this.getGPConfiguration().getRandomGenerator().nextFloat() * range);
                if ((double)newValueI < this.m_lowerBounds || (double)newValueI > this.m_upperBounds) {
                    this.setRandomValue(this.m_value_int);
                } else {
                    this.setValue(newValueI);
                }
            } else if (retType == CommandGene.LongClass) {
                double range = (this.m_upperBounds - this.m_lowerBounds) * a_percentage;
                long newValueL = (double)this.m_value_long >= (this.m_upperBounds - this.m_lowerBounds) / 2.0 ? this.m_value_long - Math.round((double)this.getGPConfiguration().getRandomGenerator().nextInt() * range) : this.m_value_long + Math.round((double)this.getGPConfiguration().getRandomGenerator().nextFloat() * range);
                if ((double)newValueL < this.m_lowerBounds || (double)newValueL > this.m_upperBounds) {
                    this.setRandomValue(this.m_value_long);
                } else {
                    this.setValue(newValueL);
                }
            }
        }
        return this;
    }

    public String toString() {
        Class retType = this.getReturnType();
        if (retType == CommandGene.FloatClass) {
            return "" + this.m_value_float;
        }
        if (retType == CommandGene.IntegerClass) {
            return "" + this.m_value_int;
        }
        if (retType == CommandGene.LongClass) {
            return "" + this.m_value_long;
        }
        if (retType == CommandGene.DoubleClass) {
            return "" + this.m_value_double;
        }
        return "unknown terminal type: " + retType;
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        return this.m_value_int;
    }

    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        return this.m_value_long;
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        return this.m_value_float;
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        return this.m_value_double;
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        StringBuffer value = new StringBuffer("(");
        Class retType = this.getReturnType();
        if (retType == CommandGene.FloatClass) {
            value.append(this.m_value_float).append("f");
        } else if (retType == CommandGene.DoubleClass) {
            value.append(this.m_value_double).append("d");
        } else if (retType == CommandGene.IntegerClass) {
            value.append(this.m_value_int);
        } else if (retType == CommandGene.LongClass) {
            value.append(this.m_value_long).append("l");
        }
        value.append(")");
        return value;
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return null;
    }

    public Object clone() {
        try {
            Terminal result = new Terminal(this.getGPConfiguration(), this.getReturnType(), this.m_lowerBounds, this.m_upperBounds, this.m_wholeNumbers, this.getSubReturnType(), false);
            result.m_value_double = this.m_value_double;
            result.m_value_float = this.m_value_float;
            result.m_value_int = this.m_value_int;
            result.m_value_long = this.m_value_long;
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }
}

